/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.OutputStream;
import jetbrains.buildServer.ExecResult;
import jetbrains.buildServer.StreamGobbler;
import jetbrains.buildServer.serverSide.TeamCityProperties;

public class CommandLineExecutor {
    private final ExecResult myRetVal = new ExecResult();
    private final GeneralCommandLine myCommandLine;
    private Process myProc;
    private StreamGobbler myErrorGobbler;
    private StreamGobbler myOutputGobbler;
    private OutputStream myOutputStream;
    private static final int TIMEOUT_DEF = 90;
    private static final int TIMEOUT_SECONDS = CommandLineExecutor.getTimeOutValue();
    private static final Logger LOG = Logger.getInstance((String)CommandLineExecutor.class.getName());

    private static int getTimeOutValue() {
        return TeamCityProperties.getInteger("teamcity.execution.timeout", 90);
    }

    public CommandLineExecutor(GeneralCommandLine commandLine) {
        this.myCommandLine = commandLine;
    }

    public ExecResult runProcess() throws ExecutionException {
        this.myProc = this.myCommandLine.createProcess();
        this.myErrorGobbler = new StreamGobbler(this.myProc.getErrorStream());
        this.myOutputGobbler = new StreamGobbler(this.myProc.getInputStream());
        this.myErrorGobbler.start();
        this.myOutputGobbler.start();
        return this.waitFor();
    }

    public OutputStream getOutputStream() {
        if (this.myOutputStream == null) {
            this.myOutputStream = this.myProc.getOutputStream();
        }
        return this.myOutputStream;
    }

    public ExecResult waitFor() {
        try {
            this.myRetVal.setExitCode(CommandLineExecutor.waitForProcess(this.myProc, this.myErrorGobbler, this.myOutputGobbler));
            this.myRetVal.setOutputGobbler(this.myOutputGobbler);
            this.myRetVal.setErrorGobbler(this.myErrorGobbler);
        }
        catch (Throwable e) {
            this.myRetVal.setException(e);
        }
        return this.myRetVal;
    }

    public Process getProcess() {
        return this.myProc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finalizeAll(Process proc, StreamGobbler errorGobbler, StreamGobbler outputGobbler) throws InterruptedException, IOException {
        errorGobbler.notifyProcessExit();
        outputGobbler.notifyProcessExit();
        try {
            try {
                try {
                    LOG.debug("Start waiting for error output collector thread");
                    errorGobbler.join();
                    LOG.debug("Finished waiting for error output collector thread");
                }
                finally {
                    proc.getErrorStream().close();
                }
            }
            finally {
                try {
                    LOG.debug("Start waiting for output collector thread");
                    outputGobbler.join();
                    LOG.debug("Finished waiting for output collector thread");
                }
                finally {
                    proc.getInputStream().close();
                }
            }
        }
        finally {
            proc.destroy();
        }
    }

    public static int waitForProcess(Process proc, StreamGobbler errorGobbler, StreamGobbler outputGobbler) throws InterruptedException {
        return CommandLineExecutor.waitForProcess(proc, errorGobbler, outputGobbler, TIMEOUT_SECONDS);
    }

    public static int waitForProcess(Process proc, StreamGobbler errorGobbler, StreamGobbler outputGobbler, int timeoutSeconds) throws InterruptedException {
        Integer[] result = new Integer[]{null};
        InterruptedException[] ex = new InterruptedException[1];
        LOG.debug("Start waiting for process finishing");
        Thread waitThread = CommandLineExecutor.createWaitForProcessThread(proc, errorGobbler, outputGobbler, result, ex);
        waitThread.start();
        long lastReadErr = errorGobbler.getReadLength();
        long lastReadOut = outputGobbler.getReadLength();
        while (true) {
            waitThread.join(timeoutSeconds * 1000);
            if (ex[0] != null) {
                throw ex[0];
            }
            if (result[0] != null) break;
            if (CommandLineExecutor.outputAbsent(errorGobbler, outputGobbler, lastReadErr, lastReadOut)) {
                try {
                    proc.destroy();
                }
                catch (Throwable e) {
                    LOG.debug("Failed to destroy process: " + e.toString(), e);
                }
                throw new InterruptedException("Timeout exception");
            }
            lastReadErr = errorGobbler.getReadLength();
            lastReadOut = outputGobbler.getReadLength();
        }
        LOG.debug("Stop waiting for process finishing");
        return result[0];
    }

    private static boolean outputAbsent(StreamGobbler errorGobbler, StreamGobbler outputGobbler, long lastReadErr, long lastReadOut) {
        return lastReadErr == errorGobbler.getReadLength() && lastReadOut == outputGobbler.getReadLength();
    }

    private static Thread createWaitForProcessThread(final Process proc, final StreamGobbler errorGobbler, final StreamGobbler outputGobbler, final Integer[] result, final InterruptedException[] ex) {
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    result[0] = proc.waitFor();
                    LOG.debug("Process.waitFor() finished");
                }
                catch (InterruptedException e) {
                    LOG.warn("Failed to Process.waitFor(): " + e.getLocalizedMessage(), (Throwable)e);
                    ex[0] = e;
                }
                finally {
                    try {
                        CommandLineExecutor.finalizeAll(proc, errorGobbler, outputGobbler);
                    }
                    catch (InterruptedException e) {
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }
}

