/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import java.io.OutputStream;
import jetbrains.buildServer.CommandLineExecutor;
import jetbrains.buildServer.ExecResult;
import jetbrains.buildServer.StreamGobbler;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleCommandLineProcessRunner {
    private static final Logger LOG = Logger.getInstance((String)SimpleCommandLineProcessRunner.class.getName());

    private SimpleCommandLineProcessRunner() {
    }

    public static ExecResult runCommand(@NotNull GeneralCommandLine commandLine, @Nullable byte[] input) {
        if (commandLine == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/SimpleCommandLineProcessRunner.runCommand must not be null");
        }
        return SimpleCommandLineProcessRunner.runCommand(commandLine, input, new ProcessRunCallbackAdapter());
    }

    public static ExecResult runCommand(GeneralCommandLine commandLine, @Nullable byte[] input, @NotNull RunCommandEvents eventHandler) {
        if (eventHandler == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/SimpleCommandLineProcessRunner.runCommand must not be null");
        }
        return SimpleCommandLineProcessRunner.runCommandSecure(commandLine, commandLine.getCommandLineString(), input, eventHandler);
    }

    public static ExecResult runCommandSecure(final @NotNull GeneralCommandLine commandLine, final @NotNull String commandLineToLog, final @Nullable byte[] input, final @NotNull RunCommandEvents eventHandler) {
        if (commandLine == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/SimpleCommandLineProcessRunner.runCommandSecure must not be null");
        }
        if (commandLineToLog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/SimpleCommandLineProcessRunner.runCommandSecure must not be null");
        }
        if (eventHandler == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of jetbrains/buildServer/SimpleCommandLineProcessRunner.runCommandSecure must not be null");
        }
        final ExecResult retVal = new ExecResult(commandLine.getCharset());
        LOG.debug("Start process name: " + commandLineToLog);
        int commandLineStrLimit = TeamCityProperties.getInteger("teamcity.externalProcessRunner.limitCommandLineLengthInThreadName", 1000);
        String commandLineStr = StringUtil.truncateStringValueWithDotsAtEnd(commandLine.toString(), commandLineStrLimit);
        NamedThreadFactory.executeWithNewThreadName(commandLineStr, new Runnable(){

            public void run() {
                SimpleCommandLineProcessRunner.runCommandInternal(commandLine, commandLineToLog, input, eventHandler, retVal);
            }
        });
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runCommandInternal(GeneralCommandLine commandLine, String commandLineToLog, byte[] input, RunCommandEvents eventHandler, ExecResult retVal) {
        try {
            Process proc = commandLine.createProcess();
            Integer maxOutputSize = eventHandler instanceof ProcessRunCallbackAdapter ? ((ProcessRunCallbackAdapter)eventHandler).getMaxAcceptedOutputSize() : null;
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), maxOutputSize, commandLineToLog);
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), maxOutputSize, commandLineToLog);
            errorGobbler.start();
            outputGobbler.start();
            if (input != null) {
                OutputStream out = proc.getOutputStream();
                try {
                    out.write(input);
                }
                finally {
                    out.close();
                }
            }
            eventHandler.onProcessStarted(proc);
            Integer timeout = eventHandler.getOutputIdleSecondsTimeout();
            if (timeout == null) {
                retVal.setExitCode(CommandLineExecutor.waitForProcess(proc, errorGobbler, outputGobbler));
            } else {
                retVal.setExitCode(CommandLineExecutor.waitForProcess(proc, errorGobbler, outputGobbler, timeout));
            }
            retVal.setOutputGobbler(outputGobbler);
            retVal.setErrorGobbler(errorGobbler);
            eventHandler.onProcessFinished(proc);
        }
        catch (Throwable e) {
            retVal.setException(e);
        }
    }

    public static class NoOutputTimeoutProcessRunCallbackAdapter
    extends NoOutputTimeoutRunCommandEventsAdapter {
        @Nullable
        public Integer getOutputIdleSecondsTimeout() {
            return 0;
        }
    }

    public static class ProcessRunCallbackAdapter
    extends RunCommandEventsAdapter {
    }

    public static class NoOutputTimeoutRunCommandEventsAdapter
    extends RunCommandEventsAdapter {
        @Nullable
        public Integer getOutputIdleSecondsTimeout() {
            return 0;
        }
    }

    public static class RunCommandEventsAdapter
    implements ProcessRunCallback {
        public void onProcessStarted(Process ps) {
        }

        public void onProcessFinished(Process ps) {
        }

        @Nullable
        public Integer getOutputIdleSecondsTimeout() {
            return null;
        }

        @Nullable
        public Integer getMaxAcceptedOutputSize() {
            return null;
        }
    }

    public static interface ProcessRunCallback
    extends RunCommandEvents {
        @Nullable
        public Integer getMaxAcceptedOutputSize();
    }

    public static interface RunCommandEvents {
        public void onProcessStarted(Process var1);

        public void onProcessFinished(Process var1);

        @Nullable
        public Integer getOutputIdleSecondsTimeout();
    }
}

