/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StreamGobbler
extends Thread {
    private static final Logger LOG = Logger.getInstance((String)StreamGobbler.class.getName());
    private final ByteArrayOutputStream myByteContents;
    private final InputStream myInputStream;
    private final Integer myMaxAcceptedOutputSize;
    private final String myCommandDebug;
    private String myOutput;
    private volatile boolean myProcessExited;
    private volatile boolean myEndReached;
    private volatile boolean myOutputOverload;

    public StreamGobbler(InputStream is) {
        this(is, null, "Unknown");
    }

    public StreamGobbler(InputStream inputStream, @Nullable Integer maxAcceptedOutputSize, @NotNull String commandDebug) {
        if (commandDebug == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/StreamGobbler.<init> must not be null");
        }
        this.myInputStream = inputStream;
        this.myByteContents = new ByteArrayOutputStream();
        this.myMaxAcceptedOutputSize = maxAcceptedOutputSize;
        this.myCommandDebug = commandDebug;
    }

    public void notifyProcessExit() {
        this.myProcessExited = true;
    }

    public void run() {
        byte[] buffer = new byte[8192];
        try {
            while (!this.myEndReached) {
                Thread.yield();
                boolean probablyHasMoreData = false;
                if (this.myInputStream.available() > 0) {
                    Thread.yield();
                    probablyHasMoreData = this.readBuffer(buffer);
                } else if (this.myProcessExited) break;
                if (probablyHasMoreData) continue;
                Thread.sleep(10L);
            }
        }
        catch (IOException ioe) {
            LOG.debug(ioe.getMessage(), (Throwable)ioe);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean readBuffer(byte[] buffer) throws IOException {
        int read = this.myInputStream.read(buffer, 0, buffer.length);
        if (read != -1) {
            if (this.myMaxAcceptedOutputSize == null || this.myByteContents.size() < this.myMaxAcceptedOutputSize) {
                this.myByteContents.write(buffer, 0, read);
            } else {
                LOG.warn("Too large output was read from the stream (" + this.getReadLength() + " bytes): " + this.myCommandDebug);
                this.myOutputOverload = true;
            }
            return read == buffer.length;
        }
        this.myEndReached = true;
        return false;
    }

    public String getReadString(Charset encoding) {
        if (this.myOutput == null) {
            try {
                this.myOutput = StringUtil.convertLineSeparators((String)this.myByteContents.toString(encoding.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unable to convert output to encoding " + encoding, e);
            }
        }
        return this.myOutput;
    }

    public boolean isOutputOverload() {
        return this.myOutputOverload;
    }

    public byte[] getReadBytes() {
        return this.myByteContents.toByteArray();
    }

    public long getReadLength() {
        return this.myByteContents.size();
    }
}

