/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent;

import com.intellij.util.StringBuilderSpinAllocator;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedHashSet;
import jetbrains.buildServer.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClasspathUtil {
    public static String resourceUrlToClasspathEntry(String className, URL resUrl) throws UnsupportedEncodingException {
        String path = ClasspathUtil.classNameToResourcePath(className);
        String urlStr = URLDecoder.decode(ClasspathUtil.encodePlusCharacter(resUrl.toExternalForm()), "UTF-8");
        if (resUrl.getProtocol() != null) {
            int jarSeparatorIndex;
            if ("jar".equals(resUrl.getProtocol()) && (jarSeparatorIndex = urlStr.indexOf("!")) >= 0) {
                urlStr = urlStr.substring(0, jarSeparatorIndex);
            }
            int startIndex = urlStr.indexOf(58);
            while (startIndex >= 0 && urlStr.charAt(startIndex + 1) != '/') {
                startIndex = urlStr.indexOf(58, startIndex + 1);
            }
            if (startIndex >= 0) {
                urlStr = urlStr.substring(startIndex + 1);
            }
        }
        if (ClasspathUtil.endsWith(urlStr, path)) {
            urlStr = urlStr.substring(0, urlStr.length() - path.length());
        }
        if (urlStr.startsWith("/") && urlStr.indexOf(":") == 2) {
            urlStr = urlStr.substring(1);
        }
        return new File(urlStr).getPath();
    }

    protected static boolean endsWith(String str, String suffix) {
        return suffix.length() <= str.length() && str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    @Nullable
    public static String getClasspathEntry(Class aClass) throws IOException {
        String path = ClasspathUtil.classNameToResourcePath(aClass.getName());
        URL resUrl = aClass.getResource(path);
        if (resUrl == null) {
            return null;
        }
        return ClasspathUtil.resourceUrlToClasspathEntry(aClass.getName(), resUrl);
    }

    public static String encodePlusCharacter(String orig) {
        return orig.replace("+", "%2B");
    }

    public static String classNameToResourcePath(String className) {
        return "/" + className.replace('.', '/') + ".class";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String composeClasspath(@Nullable Class[] classFromLibs, @Nullable String[] resourcesFromLibs, @Nullable Class context) {
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        if (classFromLibs != null) {
            for (Class classFromLib : classFromLibs) {
                cp.add(ResourceUtil.getResourceRoot(classFromLib));
            }
        }
        if (resourcesFromLibs != null && context != null) {
            for (String resourcesFromLib : resourcesFromLibs) {
                cp.add(ResourceUtil.getResourceRoot(context, resourcesFromLib));
            }
        }
        StringBuilder result = StringBuilderSpinAllocator.alloc();
        for (String path : cp) {
            if (result.length() > 0) {
                result.append(File.pathSeparator);
            }
            result.append(path);
        }
        String string = result.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agent/ClasspathUtil.composeClasspath must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)result);
        }
    }
}

