/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import jetbrains.buildServer.agent.ChangedFiles;
import jetbrains.buildServer.agent.IOUtil;
import jetbrains.buildServer.agent.VcsChange;

public class FirstTestsToRunProvider {
    private final List myRecentlyFailedTestCases = new ArrayList();
    private final ChangedFiles myBuildVcsChanges = ChangedFiles.create();

    private FirstTestsToRunProvider() {
    }

    public static FirstTestsToRunProvider create() {
        FirstTestsToRunProvider firstTestsToRunProvider = new FirstTestsToRunProvider();
        if (firstTestsToRunProvider.isGroupIncluded("recentlyFailed")) {
            firstTestsToRunProvider.loadRecentlyFailedTests();
        }
        return firstTestsToRunProvider;
    }

    public boolean isAvailable() {
        return this.getRiskGroupTestsParamValue() != null;
    }

    public ChangedFiles getBuildVcsChanges() {
        return this.myBuildVcsChanges;
    }

    public List getRecentlyFailedTestCases() {
        return this.myRecentlyFailedTestCases;
    }

    public VcsChange getCorrespondingChange(String className) {
        List changes = this.myBuildVcsChanges.getNewOrModifiedFiles();
        for (int i = 0; i < changes.size(); ++i) {
            VcsChange change = (VcsChange)changes.get(i);
            if (!change.isRelatedToClass(className)) continue;
            return change;
        }
        return null;
    }

    public void sortTestClasses(List testClasses, final ClassObjectDescriptor classObjectDescriptor) {
        final HashMap<String, Integer> classNamesToRunBefore = new HashMap<String, Integer>();
        Iterator it = testClasses.iterator();
        while (it.hasNext()) {
            String className = classObjectDescriptor.getName(it.next());
            VcsChange change = this.getCorrespondingChange(className);
            if (change == null) continue;
            classNamesToRunBefore.put(className, change.isPersonal() ? new Integer(0) : new Integer(1));
        }
        int orderNum = 2;
        Iterator it2 = this.getRecentlyFailedTestCases().iterator();
        while (it2.hasNext()) {
            String name = (String)it2.next();
            classNamesToRunBefore.put(name, new Integer(orderNum++));
        }
        Collections.sort(testClasses, new Comparator(){

            public int compare(Object o1, Object o2) {
                int res;
                String name1 = classObjectDescriptor.getName(o1);
                String name2 = classObjectDescriptor.getName(o2);
                Integer orderNum1 = (Integer)classNamesToRunBefore.get(name1);
                Integer orderNum2 = (Integer)classNamesToRunBefore.get(name2);
                if (orderNum1 == null) {
                    orderNum1 = new Integer(Integer.MAX_VALUE);
                }
                if (orderNum2 == null) {
                    orderNum2 = new Integer(Integer.MAX_VALUE);
                }
                if ((res = orderNum1.compareTo(orderNum2)) != 0) {
                    return res;
                }
                return name1.compareTo(name2);
            }
        });
    }

    public boolean isGroupIncluded(String groupName) {
        return this.getTestsGroupOrder(groupName) != -1;
    }

    private String getRiskGroupTestsParamValue() {
        return System.getProperty("teamcity.tests.runRiskGroupTestsFirst");
    }

    private int getTestsGroupOrder(String value) {
        String riskGroupTestsParamValue = this.getRiskGroupTestsParamValue();
        if (riskGroupTestsParamValue == null) {
            return -1;
        }
        ArrayList<String> order = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(riskGroupTestsParamValue, ",");
        while (st.hasMoreElements()) {
            String val = st.nextToken();
            if (val == null) continue;
            val = val.trim();
            order.add(val);
        }
        return order.indexOf(value);
    }

    private void loadRecentlyFailedTests() {
        String filePath = System.getProperty("teamcity.tests.recentlyFailedTests.file");
        if (filePath == null) {
            return;
        }
        File file = new File(filePath);
        if (file.exists()) {
            this.myRecentlyFailedTestCases.addAll(IOUtil.readLines(file));
        }
    }

    public static interface ClassObjectDescriptor {
        public String getName(Object var1);
    }
}

