/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildRunnerData {
    private final String myId;
    private final boolean myIsDisabled;
    private final String myRunType;
    private final String myRunnerName;
    private boolean myIsGroupStep;
    private final Collection<BuildRunnerData> myChildren;
    private final Map<String, String> myRunnerParameters;
    private final Map<String, String> myServerParameters;

    public BuildRunnerData(@NotNull String id, @NotNull String runnerType, @NotNull String runnerName, boolean isDisabled, @NotNull Map<String, String> runnerParameters, @NotNull Map<String, String> serverParameters) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/BuildRunnerData.<init> must not be null");
        }
        if (runnerType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/agentServer/BuildRunnerData.<init> must not be null");
        }
        if (runnerName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/agentServer/BuildRunnerData.<init> must not be null");
        }
        if (runnerParameters == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of jetbrains/buildServer/agentServer/BuildRunnerData.<init> must not be null");
        }
        if (serverParameters == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of jetbrains/buildServer/agentServer/BuildRunnerData.<init> must not be null");
        }
        this.myChildren = new ArrayList<BuildRunnerData>(0);
        this.myRunnerParameters = new TreeMap<String, String>();
        this.myServerParameters = new TreeMap<String, String>();
        this.myId = id;
        this.myRunType = runnerType;
        this.myRunnerName = runnerName;
        this.myIsDisabled = isDisabled;
        this.myRunnerParameters.putAll(runnerParameters);
        this.myServerParameters.putAll(serverParameters);
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/BuildRunnerData.getId must not return null");
        }
        return string;
    }

    public boolean isGroupStep() {
        return this.myIsGroupStep;
    }

    public void setChildren(@NotNull Collection<BuildRunnerData> children) {
        if (children == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/BuildRunnerData.setChildren must not be null");
        }
        this.myIsGroupStep = true;
        this.myChildren.clear();
        this.myChildren.addAll(children);
    }

    public void addChild(@NotNull BuildRunnerData child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/BuildRunnerData.addChild must not be null");
        }
        this.myIsGroupStep = true;
        this.myChildren.add(child);
    }

    @NotNull
    public Collection<BuildRunnerData> getChildren() {
        Collection<BuildRunnerData> collection = this.myChildren;
        if (collection == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/BuildRunnerData.getChildren must not return null");
        }
        return collection;
    }

    @NotNull
    public String getRunnerName() {
        String string = this.myRunnerName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/BuildRunnerData.getRunnerName must not return null");
        }
        return string;
    }

    public boolean isDisabled() {
        return this.myIsDisabled;
    }

    @NotNull
    public String getRunnerType() {
        String string = this.myRunType;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/BuildRunnerData.getRunnerType must not return null");
        }
        return string;
    }

    @NotNull
    public Map<String, String> getRunnerParameters() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(this.myRunnerParameters);
        if (treeMap == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/BuildRunnerData.getRunnerParameters must not return null");
        }
        return treeMap;
    }

    @NotNull
    public Map<String, String> getServerParameters() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(this.myServerParameters);
        if (treeMap == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/BuildRunnerData.getServerParameters must not return null");
        }
        return treeMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RunnerSettingsData");
        sb.append("{myRunType='").append(this.myRunType).append('\'');
        sb.append(", myRunnerParameters=").append(this.myRunnerParameters);
        sb.append(", myServerParameters=").append(this.myServerParameters);
        sb.append('}');
        return sb.toString();
    }
}

