/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts;

import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.artifacts.ArtifactDependency;
import jetbrains.buildServer.artifacts.BuildTagRevisionRule;
import jetbrains.buildServer.artifacts.RevisionRule;
import jetbrains.buildServer.artifacts.RevisionRules;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.parameters.ValueResolver;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseArtifactDependency
implements ArtifactDependency {
    private String mySourcePaths;
    private boolean myCleanDestinationFolder;
    private RevisionRule myRevisionRule;

    protected BaseArtifactDependency(@NotNull String sourcePaths, @NotNull RevisionRule revisionRule) {
        if (sourcePaths == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/artifacts/BaseArtifactDependency.<init> must not be null");
        }
        if (revisionRule == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/artifacts/BaseArtifactDependency.<init> must not be null");
        }
        this.myCleanDestinationFolder = false;
        this.mySourcePaths = sourcePaths;
        this.myRevisionRule = revisionRule;
    }

    @Override
    public void setCleanDestinationFolder(boolean cleanDestinationFolder) {
        this.myCleanDestinationFolder = cleanDestinationFolder;
    }

    @Override
    @NotNull
    public abstract String getSourceBuildTypeId();

    @Override
    @NotNull
    public abstract String getSourceExternalId();

    @Override
    public String getSourcePaths() {
        return this.mySourcePaths;
    }

    @Override
    public boolean isCleanDestinationFolder() {
        return this.myCleanDestinationFolder;
    }

    @Override
    public RevisionRule getRevisionRule() {
        return this.myRevisionRule;
    }

    public String toString() {
        return "build configuration: " + this.getSourceExternalId() + "; source path: " + this.mySourcePaths + "; clean destination: " + this.myCleanDestinationFolder + "; revision: " + this.myRevisionRule.getRevision();
    }

    @Override
    public abstract void setSourceBuildTypeId(@NotNull String var1);

    @Override
    public void setRevisionRule(@NotNull RevisionRule revisionRule) {
        if (revisionRule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/artifacts/BaseArtifactDependency.setRevisionRule must not be null");
        }
        this.myRevisionRule = revisionRule;
    }

    @Override
    public void setSourcePaths(@NotNull String paths) {
        if (paths == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/artifacts/BaseArtifactDependency.setSourcePaths must not be null");
        }
        this.mySourcePaths = paths;
    }

    @Override
    public void replaceReferences(@NotNull ValueResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/artifacts/BaseArtifactDependency.replaceReferences must not be null");
        }
        String resolvedSourcePaths = this.resolveValue(this.getSourcePaths(), resolver);
        this.setSourcePaths(resolvedSourcePaths);
        RevisionRule revisionRule = this.getRevisionRule();
        String branch = revisionRule.getBranch();
        if (branch != null) {
            branch = this.resolveValue(branch, resolver);
        }
        if ("buildNumber".equals(revisionRule.getName())) {
            this.setRevisionRule(RevisionRules.newBuildNumberRule(this.resolveValue(revisionRule.getRevision(), resolver)));
        } else if ("buildTag".equals(revisionRule.getName())) {
            this.setRevisionRule(RevisionRules.newBuildTagRule(this.resolveValue(((BuildTagRevisionRule)revisionRule).getBuildTag(), resolver), branch));
        } else if (branch != null) {
            this.setRevisionRule(RevisionRules.newBranchRevisionRule(revisionRule.getName(), revisionRule.getRevision(), branch));
        }
    }

    private String resolveValue(String value, ValueResolver resolver) {
        return resolver.resolve(value).getResult();
    }

    @Override
    public List<String> getReferences() {
        ArrayList<String> refs = new ArrayList<String>();
        refs.addAll(ReferencesResolverUtil.getReferences(this.getRevisionRule().getRevision()));
        refs.addAll(ReferencesResolverUtil.getReferences(this.getSourcePaths()));
        String branch = this.myRevisionRule.getBranch();
        if (branch != null) {
            refs.addAll(ReferencesResolverUtil.getReferences(branch));
        }
        return refs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseArtifactDependency that = (BaseArtifactDependency)o;
        if (this.myCleanDestinationFolder != that.myCleanDestinationFolder) {
            return false;
        }
        if (!this.myRevisionRule.equals(that.myRevisionRule)) {
            return false;
        }
        if (!this.getSourceBuildTypeId().equals(that.getSourceBuildTypeId())) {
            return false;
        }
        return this.mySourcePaths.equals(that.mySourcePaths);
    }

    public int hashCode() {
        int result = this.getSourceBuildTypeId().hashCode();
        result = 31 * result + this.mySourcePaths.hashCode();
        result = 31 * result + (this.myCleanDestinationFolder ? 1 : 0);
        result = 31 * result + this.myRevisionRule.hashCode();
        return result;
    }
}

