/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.dataStructures;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.dataStructures.BiMapper;
import jetbrains.buildServer.dataStructures.DecoratingCollection;
import jetbrains.buildServer.dataStructures.DecoratingCollectionBase;
import jetbrains.buildServer.dataStructures.DecoratingSet;
import jetbrains.buildServer.dataStructures.DecoratingSetBase;
import jetbrains.buildServer.dataStructures.Mapper;
import jetbrains.buildServer.dataStructures.NotNullMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratingMap<TK, TV, QK, QV>
implements Map<TK, TV> {
    private final Class<TK> myExternalKeyClass;
    private final Class<TV> myExternalValueClass;
    private final Map<QK, QV> myMap;
    private final BiMapper<QK, TK> myKeysMapper;
    private final BiMapper<QV, TV> myValuesMapper;

    public DecoratingMap(@NotNull Class<TK> externalKeyClass, @NotNull Class<TV> externalValueClass, @NotNull Map<QK, QV> map, @NotNull BiMapper<QK, TK> keysMapper, @NotNull BiMapper<QV, TV> valuesMapper) {
        if (externalKeyClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/dataStructures/DecoratingMap.<init> must not be null");
        }
        if (externalValueClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/dataStructures/DecoratingMap.<init> must not be null");
        }
        if (map == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/dataStructures/DecoratingMap.<init> must not be null");
        }
        if (keysMapper == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of jetbrains/buildServer/dataStructures/DecoratingMap.<init> must not be null");
        }
        if (valuesMapper == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of jetbrains/buildServer/dataStructures/DecoratingMap.<init> must not be null");
        }
        this.myExternalKeyClass = externalKeyClass;
        this.myExternalValueClass = externalValueClass;
        this.myMap = map;
        this.myKeysMapper = keysMapper;
        this.myValuesMapper = valuesMapper;
    }

    @Override
    public int size() {
        if (this.myKeysMapper instanceof NotNullMapper && this.myValuesMapper instanceof NotNullMapper) {
            return this.myMap.size();
        }
        int sz = 0;
        for (Map.Entry<QK, QV> entry : this.myMap.entrySet()) {
            if (this.myKeysMapper.mapKey(entry.getKey()) == null || this.myValuesMapper.mapKey(entry.getValue()) == null) continue;
            ++sz;
        }
        return sz;
    }

    @Override
    public boolean isEmpty() {
        for (Map.Entry<QK, QV> entry : this.myMap.entrySet()) {
            if (this.myKeysMapper.mapKey(entry.getKey()) == null || this.myValuesMapper.mapKey(entry.getValue()) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(this.myExternalKeyClass.cast(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<TK, TV> entry : this.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TV get(Object key) {
        QK internalKey = this.myKeysMapper.demapKey(this.myExternalKeyClass.cast(key));
        if (internalKey == null || this.myKeysMapper.mapKey(internalKey) == null) {
            return null;
        }
        QV qv = this.myMap.get(internalKey);
        if (qv == null) {
            return null;
        }
        return (TV)this.myValuesMapper.mapKey(qv);
    }

    @Override
    public TV put(TK key, TV value) {
        throw new UnsupportedOperationException("map is readonly");
    }

    @Override
    public TV remove(Object key) {
        throw new UnsupportedOperationException("map is readonly");
    }

    @Override
    public void putAll(Map<? extends TK, ? extends TV> m) {
        throw new UnsupportedOperationException("map is readonly");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("map is readonly");
    }

    @Override
    public Set<TK> keySet() {
        if (this.myValuesMapper instanceof NotNullMapper) {
            return new DecoratingSet<TK, QK>(this.myExternalKeyClass, this.myMap.keySet(), this.myKeysMapper);
        }
        return new DecoratingSetBase<TK, Map.Entry<TK, TV>>(this.entrySet(), new Mapper<Map.Entry<TK, TV>, TK>(){

            @Override
            public TK mapKey(@NotNull Map.Entry<TK, TV> internal) {
                if (internal == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/dataStructures/DecoratingMap$1.mapKey must not be null");
                }
                return internal.getKey();
            }
        }){

            @Override
            public boolean contains(Object o) {
                return DecoratingMap.this.containsKey(o);
            }
        };
    }

    @Override
    public Collection<TV> values() {
        if (this.myKeysMapper instanceof NotNullMapper) {
            return new DecoratingCollection<TV, QV>(this.myExternalValueClass, this.myMap.values(), this.myValuesMapper);
        }
        return new DecoratingCollectionBase<TV, Map.Entry<TK, TV>>(this.entrySet(), new Mapper<Map.Entry<TK, TV>, TV>(){

            @Override
            public TV mapKey(@NotNull Map.Entry<TK, TV> internal) {
                if (internal == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/dataStructures/DecoratingMap$3.mapKey must not be null");
                }
                return internal.getValue();
            }
        }){

            @Override
            public boolean contains(Object o) {
                return DecoratingMap.this.containsValue(o);
            }
        };
    }

    private Class<Map.Entry<TK, TV>> makeEntry() {
        Class<Map.Entry> clazz = Map.Entry.class;
        return clazz;
    }

    @Override
    public Set<Map.Entry<TK, TV>> entrySet() {
        return new DecoratingSet<Map.Entry<TK, TV>, Map.Entry<QK, QV>>(this.makeEntry(), this.myMap.entrySet(), new BiMapper<Map.Entry<QK, QV>, Map.Entry<TK, TV>>(){

            @Override
            @Nullable
            public Map.Entry<TK, TV> mapKey(@NotNull Map.Entry<QK, QV> internal) {
                if (internal == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/dataStructures/DecoratingMap$5.mapKey must not be null");
                }
                Object tk = DecoratingMap.this.myKeysMapper.mapKey(internal.getKey());
                if (tk == null) {
                    return null;
                }
                Object tv = DecoratingMap.this.myValuesMapper.mapKey(internal.getValue());
                if (tv == null) {
                    return null;
                }
                return new EntryImpl(tk, tv);
            }

            @Override
            @Nullable
            public Map.Entry<QK, QV> demapKey(@NotNull Map.Entry<TK, TV> external) {
                if (external == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/dataStructures/DecoratingMap$5.demapKey must not be null");
                }
                Object qk = DecoratingMap.this.myKeysMapper.demapKey(external.getKey());
                if (qk == null) {
                    return null;
                }
                Object qv = DecoratingMap.this.myValuesMapper.demapKey(external.getValue());
                if (qv == null) {
                    return null;
                }
                return new EntryImpl(qk, qv);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryImpl<K, V>
    extends AbstractMap.SimpleEntry<K, V> {
        private EntryImpl(@NotNull K key, @NotNull V value) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/dataStructures/DecoratingMap$EntryImpl.<init> must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/dataStructures/DecoratingMap$EntryImpl.<init> must not be null");
            }
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("map is readonly");
        }
    }
}

