/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.dataStructures;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiMapDecorator<TK, TV, TC extends Collection<TV>> {
    protected final Map<TK, TC> myMap;

    public MultiMapDecorator(Map<TK, TC> map) {
        this.myMap = map;
    }

    public void add(TK key, TV value) {
        this.getValuesInternal(key).add(value);
    }

    public void addEmpty(TK key) {
        this.getValuesInternal(key);
    }

    @NotNull
    public Collection<TV> getValues(TK key) {
        Collection collection = Collections.unmodifiableCollection(this.getValuesInternal(key));
        if (collection == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/dataStructures/MultiMapDecorator.getValues must not return null");
        }
        return collection;
    }

    public boolean containsKey(TK key) {
        return this.myMap.containsKey(key);
    }

    public void clear() {
        this.myMap.clear();
    }

    public Set<TK> keySet() {
        return this.myMap.keySet();
    }

    public Collection<TC> values() {
        return this.myMap.values();
    }

    public Set<Map.Entry<TK, TC>> entrySet() {
        return this.myMap.entrySet();
    }

    public int size() {
        return this.myMap.size();
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public void removeKey(TK key) {
        this.myMap.remove(key);
    }

    public void removeValue(TV v) {
        for (Collection tc : this.myMap.values()) {
            tc.remove(v);
        }
    }

    private TC getValuesInternal(TK key) {
        Collection<Object> list = (Collection)this.myMap.get(key);
        if (list == null) {
            list = this.createEmptyCollection();
            this.myMap.put(key, list);
        }
        return (TC)list;
    }

    public void addAll(TK key, Collection<? extends TV> values) {
        TC list = this.getValuesInternal(key);
        list.addAll(values);
    }

    public void addAll(MultiMapDecorator<TK, TV, TC> map) {
        for (Map.Entry<TK, TC> entry : map.myMap.entrySet()) {
            this.addAll(entry.getKey(), (Collection)entry.getValue());
        }
    }

    protected abstract TC createEmptyCollection();
}

