/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.log;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogInitializationException
extends Exception {
    @NotNull
    private final List<File> checkedDirs;

    LogInitializationException(@NotNull List<File> checkedDirs) {
        if (checkedDirs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/log/LogInitializationException.<init> must not be null");
        }
        super("Unable to initialize logs. The logs directories are not accessible for writing.");
        this.checkedDirs = Collections.unmodifiableList(new ArrayList<File>(checkedDirs));
    }

    LogInitializationException(@NotNull LogInitializationException lie) {
        if (lie == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/log/LogInitializationException.<init> must not be null");
        }
        super(lie.getMessage(), lie);
        this.checkedDirs = lie.checkedDirs;
    }

    @NotNull
    public List<File> getCheckedDirs() {
        List<File> list = this.checkedDirs;
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/log/LogInitializationException.getCheckedDirs must not return null");
        }
        return list;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getMessage()).append('\n');
        b.append("Checked directories: ");
        for (File dir : this.checkedDirs) {
            b.append(dir.getAbsolutePath()).append(", ");
        }
        if (!this.checkedDirs.isEmpty()) {
            b.delete(b.length() - 2, b.length());
        }
        b.append('.');
        return b.toString();
    }
}

