/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import jetbrains.buildServer.messages.Status;

public class BuildMessage1 {
    public static final String DEFAULT_FLOW_ID = "";
    private String mySourceId;
    private String myTypeId;
    private Status myStatus;
    private Date myTimestamp;
    private Object myValue;
    private Collection myTags;
    private String myFlowId = "";

    public BuildMessage1(String sourceId, String typeId, Status status, Date timestamp, Object value) {
        this(sourceId, typeId, status, timestamp, value, null);
    }

    public BuildMessage1(String sourceId, String typeId, Status status, Date timestamp, Object value, Collection tags) {
        this.mySourceId = sourceId;
        this.myTypeId = typeId;
        this.myStatus = status;
        this.myTimestamp = timestamp;
        this.myValue = value;
        this.myFlowId = DEFAULT_FLOW_ID;
        this.updateTags(tags);
    }

    public void setTimestamp(Date timestamp) {
        this.myTimestamp = timestamp;
    }

    public BuildMessage1 updateFlowId(String flowId) {
        this.myFlowId = flowId;
        return this;
    }

    public String getSourceId() {
        return this.mySourceId;
    }

    public String getTypeId() {
        return this.myTypeId;
    }

    public Status getStatus() {
        return this.myStatus;
    }

    public Date getTimestamp() {
        return this.myTimestamp;
    }

    public Object getValue() {
        return this.myValue;
    }

    public String getFlowId() {
        return this.myFlowId;
    }

    public Collection getTags() {
        return this.myTags;
    }

    public BuildMessage1 updateTags(String tag) {
        return tag == null ? null : this.updateTags(Collections.singletonList(tag));
    }

    public BuildMessage1 updateTags(Collection tags) {
        if (tags == null || tags.isEmpty()) {
            return this;
        }
        if (this.myTags == null) {
            this.myTags = new ArrayList(tags);
        } else {
            ArrayList newTags = new ArrayList(this.myTags.size() + tags.size());
            newTags.addAll(this.myTags);
            Iterator it = tags.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (this.myTags.contains(next)) continue;
                newTags.add(next);
            }
            newTags.trimToSize();
            this.myTags = newTags;
        }
        return this;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("BuildMessage1 ").append(this.myTypeId);
        b.append(' ').append(this.myValue == null ? "null" : this.myValue.toString());
        b.append(' ').append(this.mySourceId);
        b.append(' ').append(this.myStatus);
        b.append(' ').append(this.myFlowId);
        if (this.myTags != null && !this.myTags.isEmpty()) {
            b.append(" tags:'");
            Iterator i = this.myTags.iterator();
            while (i.hasNext()) {
                b.append(i.next());
                if (!i.hasNext()) continue;
                b.append(',');
            }
            b.append('\'');
        }
        return b.toString();
    }
}

