/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.parameters.ParameterResolver;
import jetbrains.buildServer.parameters.ParametersProvider;
import jetbrains.buildServer.parameters.ProcessingResult;
import jetbrains.buildServer.parameters.impl.ProcessingResultImpl;
import org.jetbrains.annotations.NotNull;

public class ChainResolver
implements ParameterResolver {
    private final List<ParameterResolver> myResolvers = new ArrayList<ParameterResolver>();

    @NotNull
    public ProcessingResult resolve(@NotNull String key, @NotNull String value, @NotNull ParametersProvider parameters) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ChainResolver.resolve must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ChainResolver.resolve must not be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ChainResolver.resolve must not be null");
        }
        ProcessingResultImpl result = new ProcessingResultImpl(value, false, true);
        for (ParameterResolver processor : this.myResolvers) {
            ProcessingResult evalResult = processor.resolve(key, result.getResult(), parameters);
            if (evalResult.isModified()) {
                result.setModified(true);
                result.setResult(evalResult.getResult());
            }
            result.setFullyResolved(evalResult.isFullyResolved());
            if (result.isFullyResolved()) continue;
            break;
        }
        ProcessingResultImpl processingResultImpl = result;
        if (processingResultImpl == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/impl/ChainResolver.resolve must not return null");
        }
        return processingResultImpl;
    }

    public void append(ParameterResolver processor) {
        this.myResolvers.add(processor);
    }
}

