/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.HashSet;
import java.util.Set;
import jetbrains.buildServer.parameters.ParameterResolver;
import jetbrains.buildServer.parameters.ParametersProvider;
import jetbrains.buildServer.parameters.ProcessingResult;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.parameters.impl.ProcessingResultImpl;
import org.jetbrains.annotations.NotNull;

public class ReferenceResolver
implements ParameterResolver {
    @NotNull
    public ProcessingResult resolve(@NotNull String key, @NotNull String value, @NotNull ParametersProvider parameters) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ReferenceResolver.resolve must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ReferenceResolver.resolve must not be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ReferenceResolver.resolve must not be null");
        }
        if (!ReferencesResolverUtil.mayContainReference(value)) {
            ProcessingResultImpl processingResultImpl = new ProcessingResultImpl(value, false, true);
            if (processingResultImpl == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/impl/ReferenceResolver.resolve must not return null");
            }
            return processingResultImpl;
        }
        ResolvedStringBuilder listener = new ResolvedStringBuilder(parameters, value);
        ReferencesResolverUtil.resolve(value, listener);
        ProcessingResult processingResult = listener.getResult();
        if (processingResult == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/impl/ReferenceResolver.resolve must not return null");
        }
        return processingResult;
    }

    private class ResolvedStringBuilder
    implements ReferencesResolverUtil.ReferencesResolverListener {
        @NotNull
        private final ParametersProvider myParametersProvider;
        private final StringBuilder myResult;
        private String myFinalResult;
        private final Set<String> mySubstitutions;
        private boolean myModified;
        private boolean myFullyResolved;
        private final String myValueToResolve;

        private ResolvedStringBuilder(@NotNull ParametersProvider parameters, String valueToResolve) {
            if (parameters == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ReferenceResolver$ResolvedStringBuilder.<init> must not be null");
            }
            if (valueToResolve == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ReferenceResolver$ResolvedStringBuilder.<init> must not be null");
            }
            this.mySubstitutions = new HashSet<String>();
            this.myModified = false;
            this.myFullyResolved = true;
            this.myParametersProvider = parameters;
            this.myValueToResolve = valueToResolve;
            this.myResult = new StringBuilder();
        }

        public ProcessingResult getResult() {
            this.calcResolveStatus();
            return new ProcessingResultImpl(this.myFinalResult, this.myModified, this.myFullyResolved);
        }

        public void appendText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ReferenceResolver$ResolvedStringBuilder.appendText must not be null");
            }
            this.myResult.append(text);
        }

        public boolean appendReference(@NotNull String referenceKey) {
            if (referenceKey == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ReferenceResolver$ResolvedStringBuilder.appendReference must not be null");
            }
            String resolved = this.myParametersProvider.get(referenceKey);
            if (resolved == null) {
                this.myFullyResolved = false;
                return false;
            }
            if (resolved.equals(this.myValueToResolve)) {
                this.myFullyResolved = false;
                return false;
            }
            this.mySubstitutions.add(resolved);
            this.appendText(resolved);
            this.myModified = true;
            return true;
        }

        private void calcResolveStatus() {
            if (this.myFinalResult == null) {
                this.myFinalResult = this.myResult.toString();
            }
            if (!this.myFullyResolved) {
                return;
            }
            for (String subs : this.mySubstitutions) {
                if (!ReferencesResolverUtil.containsReference(subs, new String[0], true)) continue;
                this.myFullyResolved = false;
                break;
            }
            this.mySubstitutions.clear();
        }
    }
}

