/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.requirements;

import java.util.Map;
import jetbrains.buildServer.XmlExternalizable;
import jetbrains.buildServer.requirements.RequirementQualifier;
import jetbrains.buildServer.requirements.RequirementType;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Requirement
implements XmlExternalizable {
    private final String myPropertyName;
    private final String myPropertyValue;
    private final RequirementType myType;

    public Requirement(@NonNls String propertyName, @Nullable String propertyValue, @NotNull RequirementType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/requirements/Requirement.<init> must not be null");
        }
        this.myPropertyName = propertyName;
        this.myPropertyValue = propertyValue;
        this.myType = type;
    }

    public final boolean match(@NotNull Map<String, String> properties, boolean ignoreCaseForEnv) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/requirements/Requirement.match must not be null");
        }
        RequirementQualifier qualifier = RequirementQualifier.getQualifierFor(this);
        return qualifier.match(this, properties, ignoreCaseForEnv);
    }

    @NotNull
    public String getPropertyName() {
        String string = this.myPropertyName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/requirements/Requirement.getPropertyName must not return null");
        }
        return string;
    }

    @NotNull
    public RequirementType getType() {
        RequirementType requirementType = this.myType;
        if (requirementType == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/requirements/Requirement.getType must not return null");
        }
        return requirementType;
    }

    @Nullable
    public String getPropertyValue() {
        return this.myPropertyValue;
    }

    @Override
    public void writeTo(Element element) {
        this.myType.writeTo(element, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Requirement that = (Requirement)o;
        if (!this.myPropertyName.equals(that.myPropertyName)) {
            return false;
        }
        if (this.myPropertyValue != null ? !this.myPropertyValue.equals(that.myPropertyValue) : that.myPropertyValue != null) {
            return false;
        }
        return this.myType.equals((Object)that.myType);
    }

    public int hashCode() {
        int result = this.myPropertyName.hashCode();
        result = 29 * result + (this.myPropertyValue != null ? this.myPropertyValue.hashCode() : 0);
        result = 29 * result + this.myType.hashCode();
        return result;
    }

    public Requirement newPropertyName(String newName) {
        return new Requirement(newName, this.getPropertyValue(), this.getType());
    }

    public String toString() {
        return this.myPropertyName + ' ' + this.myType.getDisplayName() + ' ' + this.myPropertyValue;
    }
}

