/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.requirements;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.requirements.Requirement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RequirementQualifier {
    EXACT{

        @Override
        public boolean match(Requirement requirement, Map<String, String> properties, boolean ignoreCaseForEnv) {
            String name = requirement.getPropertyName();
            if (name != null && name.startsWith(RequirementQualifier.EXACT_QUALIFIER)) {
                requirement = requirement.newPropertyName(name.substring(RequirementQualifier.EXACT_QUALIFIER.length()));
            }
            return requirement.getType().match(requirement, properties, ignoreCaseForEnv);
        }

        @Override
        public boolean matchRequirement(Requirement requirement) {
            return false;
        }
    }
    ,
    EXISTS{

        @Override
        public boolean match(Requirement requirement, Map<String, String> properties, boolean ignoreCaseForEnv) {
            String key = RequirementQualifier.splitKey(requirement.getPropertyName(), RequirementQualifier.EXISTS_QUALIFIER);
            assert (key != null);
            try {
                Pattern pattern = Pattern.compile(key);
                for (String prop : properties.keySet()) {
                    if (!pattern.matcher(prop).matches() || !requirement.newPropertyName(RequirementQualifier.EXACT_QUALIFIER + prop).match(properties, ignoreCaseForEnv)) continue;
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                Loggers.SERVER.warn("Invalid regexp " + key + ": " + e.toString());
            }
            return false;
        }

        @Override
        public boolean matchRequirement(Requirement requirement) {
            String name = requirement.getPropertyName();
            return name != null && name.startsWith(RequirementQualifier.EXISTS_QUALIFIER);
        }
    }
    ,
    ANY{

        @Override
        public boolean match(Requirement requirement, Map<String, String> properties, boolean ignoreCaseForEnv) {
            String key = RequirementQualifier.splitKey(requirement.getPropertyName(), RequirementQualifier.ANY_QUALIFIER);
            assert (key != null);
            try {
                Pattern pattern = Pattern.compile(key);
                for (String prop : properties.keySet()) {
                    if (!pattern.matcher(prop).matches() || requirement.newPropertyName(RequirementQualifier.EXACT_QUALIFIER + prop).match(properties, ignoreCaseForEnv)) continue;
                    return false;
                }
                return true;
            }
            catch (PatternSyntaxException e) {
                Loggers.SERVER.warn("Invalid regexp " + key + ": " + e.toString());
                return false;
            }
        }

        @Override
        public boolean matchRequirement(Requirement requirement) {
            String name = requirement.getPropertyName();
            return name != null && name.startsWith(RequirementQualifier.ANY_QUALIFIER);
        }
    };

    @NonNls
    public static final String SPLITTER = "=>";
    @NonNls
    public static final String ANY_QUALIFIER = "Any=>";
    @NonNls
    public static final String EXISTS_QUALIFIER = "Exists=>";
    @NonNls
    public static final String EXACT_QUALIFIER = "Exact=>";

    public abstract boolean match(Requirement var1, Map<String, String> var2, boolean var3);

    public abstract boolean matchRequirement(Requirement var1);

    @Nullable
    private static String splitKey(String key, String qualifier) {
        if (!key.startsWith(qualifier)) {
            return null;
        }
        return key.substring(qualifier.length());
    }

    @NotNull
    public static RequirementQualifier getQualifierFor(Requirement requirement) {
        for (RequirementQualifier qualifier : RequirementQualifier.values()) {
            if (!qualifier.matchRequirement(requirement)) continue;
            RequirementQualifier requirementQualifier = qualifier;
            if (requirementQualifier == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/requirements/RequirementQualifier.getQualifierFor must not return null");
            }
            return requirementQualifier;
        }
        RequirementQualifier requirementQualifier = EXACT;
        if (requirementQualifier == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/requirements/RequirementQualifier.getQualifierFor must not return null");
        }
        return requirementQualifier;
    }
}

