/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.requirements;

import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.requirements.Requirement;
import jetbrains.buildServer.requirements.RequirementType;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequirementRegistry {
    private final Map<String, RequirementType> myRegisteredFactories = new HashMap<String, RequirementType>();
    private static final RequirementRegistry ourInstance = new RequirementRegistry();

    public static RequirementRegistry getRegistry() {
        return ourInstance;
    }

    public void register(RequirementType factory) {
        this.myRegisteredFactories.put(factory.getName(), factory);
    }

    @Nullable
    public Requirement read(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/requirements/RequirementRegistry.read must not be null");
        }
        String name = element.getName();
        if (name != null && this.myRegisteredFactories.containsKey(name)) {
            RequirementType factory = this.myRegisteredFactories.get(name);
            return factory.readFrom(element);
        }
        return null;
    }

    static {
        for (RequirementType reqType : RequirementType.ALL_REQUIREMENT_TYPES) {
            RequirementRegistry.getRegistry().register(reqType);
        }
    }
}

