/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.requirements;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.requirements.Requirement;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.VersionComparatorUtil;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RequirementType {
    EXISTS("exists", "exists", false, true){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return actualValue != null;
        }

        public boolean isParameterRequired() {
            return false;
        }
    }
    ,
    NOT_EXISTS("not-exists", "does not exist", false, true){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return actualValue == null;
        }

        public boolean isParameterRequired() {
            return false;
        }
    }
    ,
    EQUALS("equals", "equals", true, true){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return requirementParameter.equals(actualValue);
        }

        public boolean isParameterCanBeEmpty() {
            return true;
        }
    }
    ,
    DOES_NOT_EQUAL("does-not-equal", "does not equal", false, true){

        public boolean matchValues(String requirementParameter, String actualValue) {
            if (requirementParameter.length() == 0) {
                return !StringUtil.isEmpty((String)actualValue);
            }
            return !requirementParameter.equals(actualValue);
        }

        public boolean isParameterCanBeEmpty() {
            return true;
        }
    }
    ,
    MORE_THAN("more-than", "is more than", true, false){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return Double.parseDouble(actualValue) > Double.parseDouble(requirementParameter);
        }
    }
    ,
    NO_MORE_THAN("no-more-than", "is not more than", true, false){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return Double.parseDouble(actualValue) <= Double.parseDouble(requirementParameter);
        }
    }
    ,
    LESS_THAN("less-than", "is less than", true, false){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return Double.parseDouble(actualValue) < Double.parseDouble(requirementParameter);
        }
    }
    ,
    NO_LESS_THAN("no-less-than", "is not less than", true, false){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return Double.parseDouble(actualValue) >= Double.parseDouble(requirementParameter);
        }
    }
    ,
    STARTS_WITH("starts-with", "starts with", true, false){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return actualValue.startsWith(requirementParameter);
        }
    }
    ,
    CONTAINS("contains", "contains", true, false){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return actualValue.indexOf(requirementParameter) >= 0;
        }
    }
    ,
    DOES_NOT_CONTAIN("does-not-contain", "does not contain", false, true){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return actualValue == null || !CONTAINS.matchValues(requirementParameter, actualValue);
        }
    }
    ,
    ENDS_WITH("ends-with", "ends with", true, false){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return actualValue.endsWith(requirementParameter);
        }
    }
    ,
    MATCHES("matches", "matches", true, false){

        public boolean matchValues(String requirementParameter, String actualValue) {
            try {
                return actualValue.matches(requirementParameter);
            }
            catch (PatternSyntaxException e) {
                Loggers.SERVER.warn("Invalid regexp " + requirementParameter + ": " + e.toString());
                return false;
            }
        }
    }
    ,
    DOES_NOT_MATCH("does-not-match", "does not match", false, true){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return actualValue == null || !MATCHES.matchValues(requirementParameter, actualValue);
        }
    }
    ,
    VER_MORE_THAN("ver-more-than", "version is more than", true, false){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return VersionComparatorUtil.compare(actualValue, requirementParameter) > 0;
        }
    }
    ,
    VER_NO_MORE_THAN("ver-no-more-than", "version is not more than", true, false){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return VersionComparatorUtil.compare(actualValue, requirementParameter) <= 0;
        }
    }
    ,
    VER_LESS_THAN("ver-less-than", "version is less than", true, false){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return VersionComparatorUtil.compare(actualValue, requirementParameter) < 0;
        }
    }
    ,
    VER_NO_LESS_THAN("ver-no-less-than", "version is not less than", true, false){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return VersionComparatorUtil.compare(actualValue, requirementParameter) >= 0;
        }
    }
    ,
    ANY("any", "any value (parameter is not required)", false, true){

        public boolean matchValues(String requirementParameter, String actualValue) {
            return true;
        }

        public boolean isParameterRequired() {
            return false;
        }
    };

    private final String myName;
    private final String myDisplayName;
    private final boolean myValueRequired;
    private final boolean myValueCanBeEmpty;
    private static final String NAME = "name";
    private static final String VALUE = "value";
    public static final List<RequirementType> ALL_REQUIREMENT_TYPES;

    private RequirementType(String name, String displayName, boolean valueRequired, boolean valueCanBeEmpty) {
        this.myName = name;
        this.myDisplayName = displayName;
        this.myValueRequired = valueRequired;
        this.myValueCanBeEmpty = valueCanBeEmpty;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public final String getName() {
        return this.myName;
    }

    @Nullable
    public Requirement readFrom(Element xmlElement) {
        String propName = xmlElement.getAttributeValue(NAME);
        String propValue = xmlElement.getAttributeValue(VALUE);
        if (propName == null) {
            return null;
        }
        if (this.isParameterRequired() && propValue == null) {
            return null;
        }
        return this.readInternal(propName, propValue);
    }

    public void writeTo(Element xmlElement, Requirement requirementParameter) {
        Element contentElement = new Element(this.getName());
        xmlElement.addContent((Content)contentElement);
        contentElement.setAttribute(NAME, requirementParameter.getPropertyName());
        if (this.isParameterRequired()) {
            contentElement.setAttribute(VALUE, requirementParameter.getPropertyValue());
        }
    }

    @Nullable
    public static RequirementType findByName(String name) {
        for (RequirementType rt : ALL_REQUIREMENT_TYPES) {
            if (!rt.getName().equals(name)) continue;
            return rt;
        }
        return null;
    }

    protected Requirement readInternal(String propName, String propValue) {
        return new Requirement(propName, propValue, this);
    }

    public boolean isParameterRequired() {
        return true;
    }

    public boolean isParameterCanBeEmpty() {
        return !this.isParameterRequired();
    }

    public boolean isActualValueRequired() {
        return this.myValueRequired;
    }

    public boolean isActualValueCanBeEmpty() {
        return this.myValueCanBeEmpty;
    }

    public abstract boolean matchValues(String var1, String var2);

    public boolean match(Requirement requirement, Map<String, String> properties, boolean ignoreCaseForEnv) {
        try {
            String value;
            String reqParam = requirement.getPropertyValue();
            if (!this.checkRequirementParameter(reqParam)) {
                return false;
            }
            PropDesc propDesc = RequirementType.getProp(requirement.getPropertyName(), properties, ignoreCaseForEnv);
            if (this.isActualValueRequired() && (propDesc == null || propDesc.myValue == null)) {
                return false;
            }
            String string = value = propDesc == null ? null : propDesc.myValue;
            if (!(this.isActualValueCanBeEmpty() || value != null && value.length() != 0)) {
                return false;
            }
            return this.matchValues(reqParam, value);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkRequirementParameter(String reqValue) {
        if (this.isParameterRequired() && reqValue == null) {
            return false;
        }
        return this.isParameterCanBeEmpty() || reqValue != null && reqValue.length() != 0;
    }

    @Nullable
    private static PropDesc getProp(@NotNull String propName, @NotNull Map<String, String> properties, boolean ignoreCaseForEnv) {
        if (propName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/requirements/RequirementType.getProp must not be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/requirements/RequirementType.getProp must not be null");
        }
        PropDesc result = null;
        if (ignoreCaseForEnv && propName.startsWith("env.")) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (propName.compareToIgnoreCase(entry.getKey()) != 0) continue;
                result = new PropDesc(entry.getKey(), entry.getValue());
                break;
            }
        } else if (properties.containsKey(propName)) {
            result = new PropDesc(propName, properties.get(propName));
        }
        return result;
    }

    static {
        ALL_REQUIREMENT_TYPES = Arrays.asList(RequirementType.class.getEnumConstants());
    }

    private static class PropDesc {
        @NotNull
        public final String myName;
        @Nullable
        public final String myValue;

        private PropDesc(@NotNull String name, @Nullable String value) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/requirements/RequirementType$PropDesc.<init> must not be null");
            }
            this.myName = name;
            this.myValue = value;
        }
    }
}

