/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.runner;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import jetbrains.buildServer.RunBuildException;
import jetbrains.buildServer.agent.AgentRuntimeProperties;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.PropertiesUtil;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildFileRunnerUtil {
    private static final Logger LOG = Logger.getInstance((String)BuildFileRunnerUtil.class.getName());

    private BuildFileRunnerUtil() {
    }

    public static boolean isCustomBuildFileUsed(Map<String, String> runParameters) {
        return PropertiesUtil.getBoolean(runParameters.get("use-custom-build-file"));
    }

    @NotNull
    public static File getBuildFile(@NotNull Map<String, String> runParameters) throws RunBuildException {
        if (runParameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/runner/BuildFileRunnerUtil.getBuildFile must not be null");
        }
        boolean useCustomBuildFile = BuildFileRunnerUtil.isCustomBuildFileUsed(runParameters);
        File checkoutDir = new File(AgentRuntimeProperties.getCheckoutDir(runParameters));
        if (useCustomBuildFile) {
            File file;
            String buildFileContent = runParameters.get("build-file");
            if (PropertiesUtil.isEmptyOrNull(buildFileContent)) {
                throw new RunBuildException("Build file content is not specified. Please review build configuration settings and check whether build file is correct.");
            }
            try {
                File tempFile = File.createTempFile("build", null, checkoutDir);
                FileUtil.writeFile(tempFile, buildFileContent);
                file = tempFile;
            }
            catch (IOException e) {
                LOG.error("Failed to create build file in the directory: " + checkoutDir);
                throw new RuntimeException(e);
            }
            if (file == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/runner/BuildFileRunnerUtil.getBuildFile must not return null");
            }
            return file;
        }
        String buildFilePath = runParameters.get("build-file-path");
        if (PropertiesUtil.isEmptyOrNull(buildFilePath)) {
            throw new RunBuildException("Build file path is not specified. Please review build configuration settings and check the build file path parameter.");
        }
        File buildFile = FileUtil.resolvePath(checkoutDir, buildFilePath);
        if (!buildFile.isFile()) {
            throw new RunBuildException("Cannot find build file by path specified in build configuration settings: '" + buildFile.getAbsolutePath() + "' (absolute path on agent). Please check that specified path is correct.");
        }
        File file = buildFile;
        if (file == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/runner/BuildFileRunnerUtil.getBuildFile must not return null");
        }
        return file;
    }
}

