/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.runner;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineArgumentsUtil {
    @NotNull
    public static List<String> getRunnerArgs(@NotNull Map<String, String> runnerParameters) {
        if (runnerParameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/runner/CommandLineArgumentsUtil.getRunnerArgs must not be null");
        }
        String userDefinedArguments = runnerParameters.get("runnerArgs");
        if (userDefinedArguments == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/runner/CommandLineArgumentsUtil.getRunnerArgs must not return null");
            }
            return list;
        }
        List<String> list = CommandLineArgumentsUtil.extractArguments(userDefinedArguments);
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/runner/CommandLineArgumentsUtil.getRunnerArgs must not return null");
        }
        return list;
    }

    @NotNull
    public static List<String> extractArguments(@NotNull String userDefinedArguments) {
        if (userDefinedArguments == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/runner/CommandLineArgumentsUtil.extractArguments must not be null");
        }
        List<String> list = StringUtil.splitCommandArgumentsAndUnquote(userDefinedArguments);
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/runner/CommandLineArgumentsUtil.extractArguments must not return null");
        }
        return list;
    }
}

