/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePropertiesModel
implements TeamCityProperties.Model {
    protected static final Map<String, String> EMPTY_PROPERTIES = Collections.emptyMap();

    @Override
    @Nullable
    public final String getPropertyOrNull(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/BasePropertiesModel.getPropertyOrNull must not be null");
        }
        String result = this.getUserDefinedProperty(key);
        if (result != null) {
            return result;
        }
        return this.getSystemProperty(key);
    }

    @Nullable
    protected String getSystemProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/BasePropertiesModel.getSystemProperty must not be null");
        }
        return System.getProperty(key);
    }

    @Nullable
    protected String getUserDefinedProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/BasePropertiesModel.getUserDefinedProperty must not be null");
        }
        return this.getUserDefinedProperties().get(key);
    }

    @Override
    @NotNull
    public Map<String, String> getSystemProperties() {
        Map<String, String> map = BasePropertiesModel.propertiesToMap(System.getProperties());
        if (map == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/BasePropertiesModel.getSystemProperties must not return null");
        }
        return map;
    }

    @Override
    @NotNull
    public Map<String, String> getUserDefinedProperties() {
        Map<String, String> map = EMPTY_PROPERTIES;
        if (map == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/BasePropertiesModel.getUserDefinedProperties must not return null");
        }
        return map;
    }

    @NotNull
    protected static Map<String, String> propertiesToMap(@NotNull Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/BasePropertiesModel.propertiesToMap must not be null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/BasePropertiesModel.propertiesToMap must not return null");
        }
        return hashMap;
    }
}

