/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import com.intellij.openapi.util.Pair;
import java.util.Map;
import java.util.Properties;
import jetbrains.buildServer.serverSide.BasePropertiesModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamCityProperties {
    private static volatile Model ourModel;
    private static final Model NULL_MODEL;

    public static boolean getBoolean(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getBoolean must not be null");
        }
        return Boolean.parseBoolean(TeamCityProperties.getPropertyOrNull(key));
    }

    public static boolean getBooleanOrTrue(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getBooleanOrTrue must not be null");
        }
        String result = TeamCityProperties.getProperty(key, "true");
        return Boolean.parseBoolean(result);
    }

    public static int getInteger(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getInteger must not be null");
        }
        return TeamCityProperties.getInteger(key, 0);
    }

    public static int getInteger(@NotNull String key, int defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getInteger must not be null");
        }
        String result = TeamCityProperties.getPropertyOrNull(key);
        try {
            return result != null ? Integer.parseInt(result) : Integer.getInteger(key, defaultValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static float getFloat(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getFloat must not be null");
        }
        return TeamCityProperties.getFloat(key, 0.0f);
    }

    public static float getFloat(@NotNull String key, float defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getFloat must not be null");
        }
        String result = TeamCityProperties.getPropertyOrNull(key);
        try {
            return result != null ? Float.parseFloat(result) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getLong(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getLong must not be null");
        }
        return TeamCityProperties.getLong(key, 0L);
    }

    public static long getLong(@NotNull String key, long defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getLong must not be null");
        }
        String result = TeamCityProperties.getPropertyOrNull(key);
        try {
            return result != null ? Long.parseLong(result) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @NotNull
    public static String getProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getProperty must not be null");
        }
        String string = TeamCityProperties.getProperty(key, "");
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties.getProperty must not return null");
        }
        return string;
    }

    @Nullable
    public static String getPropertyOrNull(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getPropertyOrNull must not be null");
        }
        return TeamCityProperties.get(key);
    }

    @Nullable
    public static String getPropertyOrNull(@NotNull String key, @Nullable String defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getPropertyOrNull must not be null");
        }
        String result = TeamCityProperties.get(key);
        return result != null ? result : defaultValue;
    }

    @NotNull
    public static String getProperty(@NotNull String key, @NotNull String defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getProperty must not be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getProperty must not be null");
        }
        String result = TeamCityProperties.get(key);
        String string = result != null ? result : defaultValue;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties.getProperty must not return null");
        }
        return string;
    }

    @NotNull
    public static Pair<Properties, Properties> getAllProperties() {
        Model model = TeamCityProperties.getModel();
        Map<String, String> userPropertiesMap = model.getUserDefinedProperties();
        Map<String, String> systemPropertiesMap = model.getSystemProperties();
        Properties userProperties = new Properties();
        userProperties.putAll(userPropertiesMap);
        Properties systemProperties = new Properties();
        systemProperties.putAll(systemPropertiesMap);
        Pair pair = new Pair((Object)userProperties, (Object)systemProperties);
        if (pair == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties.getAllProperties must not return null");
        }
        return pair;
    }

    @Nullable
    private static String get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.get must not be null");
        }
        return TeamCityProperties.getModel().getPropertyOrNull(key);
    }

    @NotNull
    public static Model getModel() {
        if (ourModel == null) {
            Model model = NULL_MODEL;
            if (model == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties.getModel must not return null");
            }
            return model;
        }
        Model model = ourModel;
        if (model == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties.getModel must not return null");
        }
        return model;
    }

    protected static void setModel(@NotNull Model model) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.setModel must not be null");
        }
        ourModel = model;
    }

    static {
        NULL_MODEL = new Model(){
            private final Model myHost = new BasePropertiesModel(){};
            private final String OUR_CLASS_NAME = TeamCityProperties.class.getName();

            @Override
            @Nullable
            public String getPropertyOrNull(@NotNull String key) {
                if (key == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties$1.getPropertyOrNull must not be null");
                }
                this.warnIncorrectUsage(key);
                return this.myHost.getPropertyOrNull(key);
            }

            @Override
            @NotNull
            public Map<String, String> getSystemProperties() {
                this.warnIncorrectUsage(null);
                Map<String, String> map = this.myHost.getSystemProperties();
                if (map == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties$1.getSystemProperties must not return null");
                }
                return map;
            }

            @Override
            @NotNull
            public Map<String, String> getUserDefinedProperties() {
                this.warnIncorrectUsage(null);
                Map<String, String> map = this.myHost.getUserDefinedProperties();
                if (map == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties$1.getUserDefinedProperties must not return null");
                }
                return map;
            }

            private void warnIncorrectUsage(@Nullable String propertyName) {
                String baseMessage = propertyName != null ? "Attempt to read TeamCity internal property \"" + propertyName + "\" before initialization! Default value is used." : "Attempt to read TeamCity internal properties before initialization!";
                try {
                    boolean foundSelf = false;
                    for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                        if (this.OUR_CLASS_NAME.equals(element.getClassName())) {
                            foundSelf = true;
                            continue;
                        }
                        if (!foundSelf) continue;
                        System.out.println(baseMessage + " Callee: " + element.toString());
                        return;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                System.out.println(baseMessage);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Model {
        @Nullable
        public String getPropertyOrNull(@NotNull String var1);

        @NotNull
        public Map<String, String> getSystemProperties();

        @NotNull
        public Map<String, String> getUserDefinedProperties();
    }
}

