/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import jetbrains.buildServer.serverSide.FileWatchingPropertiesModel;
import jetbrains.buildServer.serverSide.TeamCityServerProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamCityServerPropertiesModel
extends FileWatchingPropertiesModel {
    private final Map<String, String> mySystemProps;

    public TeamCityServerPropertiesModel() {
        this(TeamCityServerProperties.getDataPath());
    }

    public TeamCityServerPropertiesModel(@NotNull String dataPath) {
        if (dataPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityServerPropertiesModel.<init> must not be null");
        }
        super(new File(new File(dataPath, "config"), "internal.properties"));
        this.mySystemProps = Collections.unmodifiableMap(TeamCityServerPropertiesModel.propertiesToMap(System.getProperties()));
    }

    @Override
    @Nullable
    protected String getSystemProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityServerPropertiesModel.getSystemProperty must not be null");
        }
        if (this.mySystemProps == null) {
            return System.getProperty(key);
        }
        return this.mySystemProps.get(key);
    }

    @Override
    @NotNull
    public Map<String, String> getSystemProperties() {
        if (this.mySystemProps == null) {
            Map<String, String> map = TeamCityServerPropertiesModel.propertiesToMap(System.getProperties());
            if (map == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityServerPropertiesModel.getSystemProperties must not return null");
            }
            return map;
        }
        Map<String, String> map = this.mySystemProps;
        if (map == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityServerPropertiesModel.getSystemProperties must not return null");
        }
        return map;
    }
}

