/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.vcs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import jetbrains.buildServer.vcs.IncludeRule;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.VcsRootEntry;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckedOutDir
implements Comparable<CheckedOutDir> {
    private final VcsRoot myRoot;
    private final IncludeRule myRule;

    public CheckedOutDir(VcsRoot root, IncludeRule rule) {
        this.myRoot = root;
        this.myRule = rule;
    }

    public VcsRoot getRoot() {
        return this.myRoot;
    }

    public IncludeRule getRule() {
        return this.myRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckedOutDir that = (CheckedOutDir)o;
        if (this.myRoot.getId() != that.myRoot.getId()) {
            return false;
        }
        return this.myRule.equals(that.myRule);
    }

    public int hashCode() {
        int result = (int)this.myRoot.getId();
        result = 31 * result + this.myRule.hashCode();
        return result;
    }

    @NotNull
    public static List<CheckedOutDir> createListFor(@NotNull List<? extends VcsRootEntry> entries) {
        if (entries == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/vcs/CheckedOutDir.createListFor must not be null");
        }
        ArrayList<CheckedOutDir> result = new ArrayList<CheckedOutDir>();
        for (VcsRootEntry vcsRootEntry : entries) {
            for (IncludeRule includeRule : vcsRootEntry.getCheckoutRules().getIncludeRules()) {
                result.add(new CheckedOutDir(vcsRootEntry.getVcsRoot(), includeRule));
            }
        }
        ArrayList<CheckedOutDir> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/vcs/CheckedOutDir.createListFor must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static List<CheckedOutDir> findCheckedOutDirsByPath(@NotNull String path, @NotNull List<? extends VcsRootEntry> entries) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/vcs/CheckedOutDir.findCheckedOutDirsByPath must not be null");
        }
        if (entries == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/serverSide/vcs/CheckedOutDir.findCheckedOutDirsByPath must not be null");
        }
        LinkedHashSet<CheckedOutDir> result = new LinkedHashSet<CheckedOutDir>();
        ArrayList<CheckedOutDir> checkedOutDirs = new ArrayList<CheckedOutDir>(CheckedOutDir.createListFor(entries));
        Collections.sort(checkedOutDirs, new Comparator<CheckedOutDir>(){

            @Override
            public int compare(CheckedOutDir o1, CheckedOutDir o2) {
                return -o1.getRule().getTo().compareTo(o2.getRule().getTo());
            }
        });
        for (CheckedOutDir checkedOutDir : checkedOutDirs) {
            String dirToCheckOutTo = checkedOutDir.getRule().getTo();
            if (!path.startsWith(dirToCheckOutTo)) continue;
            result.add(checkedOutDir);
        }
        ArrayList<CheckedOutDir> arrayList = new ArrayList<CheckedOutDir>(result);
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/vcs/CheckedOutDir.findCheckedOutDirsByPath must not return null");
        }
        return arrayList;
    }

    @Override
    public int compareTo(CheckedOutDir o) {
        return this.getRule().getTo().compareTo(o.getRule().getTo());
    }

    public String toString() {
        return "CheckedOutDir{myRoot=" + this.myRoot + ", myRule=" + this.myRule + '}';
    }
}

