/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private static final int DEFAULT_BUF_SIZE = 2048;
    private ByteBuffer myByteBuffer;
    private long myFilePos = 0L;

    public BufferedRandomAccessFile(File file, String mode) throws FileNotFoundException {
        super(file, mode);
        this.initBuffer(2048);
    }

    public BufferedRandomAccessFile(File file, String mode, int bufSize) throws FileNotFoundException {
        super(file, mode);
        this.initBuffer(bufSize);
    }

    private void initBuffer(int bufSize) {
        this.myByteBuffer = ByteBuffer.allocate(bufSize);
        this.myByteBuffer.position(this.myByteBuffer.limit());
    }

    public int read() throws IOException {
        this.fillBufferIfNeeded();
        if (this.isBufferEmpty()) {
            return -1;
        }
        return this.nextByte() & 0xFF;
    }

    private void fillBufferIfNeeded() throws IOException {
        if (!this.myByteBuffer.hasRemaining()) {
            this.fillBuffer();
        }
    }

    private boolean isBufferEmpty() {
        return this.myByteBuffer.limit() == 0;
    }

    private byte nextByte() {
        ++this.myFilePos;
        return this.myByteBuffer.get();
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
        this.fillBufferIfNeeded();
        if (this.isBufferEmpty()) {
            return -1;
        }
        int readBytes = 0;
        for (int i = off; i < len; ++i) {
            bytes[i] = this.nextByte();
            ++readBytes;
            this.fillBufferIfNeeded();
            if (this.isBufferEmpty()) break;
        }
        return readBytes;
    }

    private void fillBuffer() throws IOException {
        this.myByteBuffer.clear();
        int readBytes = super.read(this.myByteBuffer.array(), 0, this.myByteBuffer.capacity());
        if (readBytes > 0) {
            this.myByteBuffer.limit(readBytes);
        } else {
            this.myByteBuffer.limit(0);
        }
        this.myByteBuffer.position(0);
    }

    public void seek(long pos) throws IOException {
        int bufRemaining = this.myByteBuffer.remaining();
        int bufCapacity = (int)(this.myFilePos + (long)bufRemaining - pos);
        if (bufCapacity > 0 && bufCapacity < this.myByteBuffer.limit()) {
            this.myByteBuffer.position(this.myByteBuffer.limit() - bufCapacity);
            this.myFilePos = pos;
        } else if (pos != this.myFilePos) {
            super.seek(pos);
            this.myFilePos = super.getFilePointer();
            this.myByteBuffer.clear();
            this.myByteBuffer.position(this.myByteBuffer.limit());
        }
    }

    public long getFilePointer() throws IOException {
        return this.myFilePos;
    }

    public void write(int b) throws IOException {
        super.write(b);
        ++this.myFilePos;
    }
}

