/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveMap<T>
implements Map<String, T> {
    @NotNull
    private final Map<String, T> myOriginalBuildParams;
    @NotNull
    private final Map<String, String> myAssoc;

    public CaseInsensitiveMap() {
        this.myAssoc = new TreeMap<String, String>();
        this.myOriginalBuildParams = new TreeMap<String, T>();
    }

    public CaseInsensitiveMap(@NotNull Map<String, T> source) {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CaseInsensitiveMap.<init> must not be null");
        }
        this.myAssoc = new TreeMap<String, String>();
        this.myOriginalBuildParams = new TreeMap<String, T>(source);
        for (Map.Entry<String, T> entry : this.myOriginalBuildParams.entrySet()) {
            String key = entry.getKey();
            String upperCaseKey = key.toUpperCase();
            this.myAssoc.put(upperCaseKey, key);
        }
    }

    @Override
    public int size() {
        return this.myOriginalBuildParams.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myOriginalBuildParams.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.isAssocExists((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myOriginalBuildParams.containsValue(value);
    }

    @Override
    public T get(Object key) {
        if (key instanceof String && this.isAssocExists((String)key)) {
            return this.myOriginalBuildParams.get(this.myAssoc.get(((String)key).toUpperCase()));
        }
        return this.myOriginalBuildParams.get(key);
    }

    @Override
    public T put(String key, T value) {
        if (!this.isAssocExists(key)) {
            this.myAssoc.put(key.toUpperCase(), key);
        }
        return this.myOriginalBuildParams.put(this.myAssoc.get(key.toUpperCase()), value);
    }

    @Override
    public T remove(Object key) {
        if (key instanceof String && this.isAssocExists((String)key)) {
            String origKey = this.myAssoc.remove(((String)key).toUpperCase());
            return this.myOriginalBuildParams.remove(origKey);
        }
        return this.myOriginalBuildParams.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> t) {
        for (Map.Entry<String, T> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.myOriginalBuildParams.clear();
        this.myAssoc.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.myOriginalBuildParams.keySet();
    }

    @Override
    public Collection<T> values() {
        return this.myOriginalBuildParams.values();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.myOriginalBuildParams.entrySet();
    }

    public String toString() {
        return this.myOriginalBuildParams.toString();
    }

    private boolean isAssocExists(String keyStr) {
        String upperCaseKey;
        boolean result = false;
        if (keyStr != null && this.myAssoc.containsKey(upperCaseKey = keyStr.toUpperCase())) {
            String origKey = this.myAssoc.get(upperCaseKey);
            if (!this.myOriginalBuildParams.containsKey(origKey)) {
                this.myAssoc.remove(upperCaseKey);
            } else {
                result = true;
            }
        }
        return result;
    }
}

