/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Couple<T> {
    public final T a;
    public final T b;

    public static <TT> Couple<TT> of(TT a, TT b) {
        return new Couple<TT>(a, b);
    }

    public Couple(T a, T b) {
        this.a = a;
        this.b = b;
    }

    public Couple(@NotNull T[] ab) {
        if (ab == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/Couple.<init> must not be null");
        }
        if (ab.length != 2) {
            throw new IllegalArgumentException("Expected and array of two items but given an array of " + ab.length + " ones.");
        }
        this.a = ab[0];
        this.b = ab[1];
    }

    public final T getA() {
        return this.a;
    }

    public final T getB() {
        return this.b;
    }

    public final T get(int index) {
        switch (index) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
        }
        throw new IllegalArgumentException("Expected index 0 or 1 but got " + index);
    }

    public boolean equals(Couple<T> that) {
        return this == that || that != null && Couple.areEqual(this.a, that.a) && Couple.areEqual(this.b, that.b);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (thatObject == null || this.getClass() != thatObject.getClass()) {
            return false;
        }
        Couple that = (Couple)thatObject;
        return Couple.areEqual(this.a, that.a) && Couple.areEqual(this.b, that.b);
    }

    public int hashCode() {
        int h = 0;
        if (this.a != null) {
            h += this.a.hashCode();
        }
        if (this.b != null) {
            h += this.b.hashCode();
        }
        return h;
    }

    private static <X> boolean areEqual(X a, X b) {
        return a == b || a != null && b != null && a.equals(b);
    }

    public String toString() {
        return '<' + (this.a == null ? "null" : this.a.toString()) + '/' + (this.b == null ? "null" : this.b.toString()) + '>';
    }
}

