/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.zip.GZIPOutputStream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import jetbrains.buildServer.util.Dates;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticUtil {
    private static final String FILE_DATE_FORMAT = "yyyy-MM-dd_HH.mm.ss";
    public static final String THREAD_DUMP_PREFIX = "threadDump-";
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";

    public static void threadDumpToLog(ExecutorService executorService) {
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadFactory factory = ((ThreadPoolExecutor)executorService).getThreadFactory();
            if (factory instanceof NamedThreadFactory) {
                NamedThreadFactory namedThreadFactory = (NamedThreadFactory)factory;
                DiagnosticUtil.threadDumpToLog(namedThreadFactory);
            } else {
                StringWriter writer = new StringWriter();
                new Exception("Stack trace").printStackTrace(new PrintWriter(writer));
                DiagnosticUtil.warnToThreadFactoryLogger(writer.toString());
            }
        }
    }

    public static void threadDumpToLog(@NotNull NamedThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/DiagnosticUtil.threadDumpToLog must not be null");
        }
        DiagnosticUtil.warnToThreadFactoryLogger(threadFactory.getThreadDump());
    }

    private static void warnToThreadFactoryLogger(String threadDump) {
        Logger.getInstance((String)"jetbrains.buildServer.util.NamedThreadFactory").warn(threadDump);
    }

    public static void threadDumpToStream(final @NotNull PrintStream out) {
        if (out == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/DiagnosticUtil.threadDumpToStream must not be null");
        }
        DiagnosticUtil.jvm5ThreadDumpInternal(new Printer(){

            public void println(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/DiagnosticUtil$1.println must not be null");
                }
                out.println(text);
            }

            public void println() {
                out.println();
            }

            public void print(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/DiagnosticUtil$1.print must not be null");
                }
                out.print(text);
            }
        });
    }

    public static void threadDumpToStream(final @NotNull PrintWriter out) {
        if (out == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/DiagnosticUtil.threadDumpToStream must not be null");
        }
        DiagnosticUtil.jvm5ThreadDumpInternal(new Printer(){

            public void println(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/DiagnosticUtil$2.println must not be null");
                }
                out.println(text);
            }

            public void println() {
                out.println();
            }

            public void print(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/DiagnosticUtil$2.print must not be null");
                }
                out.print(text);
            }
        });
    }

    public static File threadDumpToDirectory(@Nullable File dir, @Nullable String summary) {
        if (dir != null && !dir.isDirectory()) {
            throw new IllegalArgumentException("Specified path is not a directory: " + dir.getAbsolutePath());
        }
        File threadDump = DiagnosticUtil.getDiagnosticFile(dir, THREAD_DUMP_PREFIX, ".txt");
        String dump = DiagnosticUtil.threadDumpToString();
        FileUtil.writeFile(threadDump, summary == null ? dump : summary + "\n" + dump);
        return threadDump;
    }

    private static File getDiagnosticFile(@Nullable File baseDir, @NotNull String prefix, @NotNull String ext) {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/DiagnosticUtil.getDiagnosticFile must not be null");
        }
        if (ext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/DiagnosticUtil.getDiagnosticFile must not be null");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(FILE_DATE_FORMAT);
        File parentDir = baseDir == null ? new File(".") : baseDir;
        return new File(parentDir, prefix + sdf.format(Dates.now()) + ext).getAbsoluteFile();
    }

    @NotNull
    public static String threadDumpToString() {
        final StringBuilder sb = new StringBuilder();
        DiagnosticUtil.jvm5ThreadDumpInternal(new Printer(){

            public void println(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/DiagnosticUtil$3.println must not be null");
                }
                this.print(text);
                this.println();
            }

            public void println() {
                sb.append("\n");
            }

            public void print(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/DiagnosticUtil$3.print must not be null");
                }
                sb.append(text);
            }
        });
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/DiagnosticUtil.threadDumpToString must not return null");
        }
        return string;
    }

    private static void jvm5ThreadDumpInternal(Printer out) {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        ThreadMXBean bean = DiagnosticUtil.getThreadsBean();
        long currentThreadId = Thread.currentThread().getId();
        DiagnosticUtil.printHeader(out);
        for (Map.Entry<Thread, StackTraceElement[]> e : map.entrySet()) {
            ThreadGroup group;
            StackTraceElement[] el = e.getValue();
            Thread t = e.getKey();
            if (currentThreadId == t.getId()) continue;
            out.print(MessageFormat.format("\"{0}\" ", t.getName()));
            if (t.isDaemon()) {
                out.print("daemon ");
            }
            if ((group = t.getThreadGroup()) != null) {
                out.print(MessageFormat.format("group=\"{0}\" ", group.getName()));
            }
            out.print(MessageFormat.format("prio={0} ", t.getPriority()));
            out.print(MessageFormat.format("tid={0} ", t.getId()));
            out.print(MessageFormat.format("nid={0} ", t.getId()));
            Thread.State state = t.getState();
            if (state == Thread.State.RUNNABLE) {
                out.print("runnable ");
            }
            if (state == Thread.State.WAITING || state == Thread.State.TIMED_WAITING) {
                out.print("waiting ");
            }
            if (state == Thread.State.BLOCKED) {
                out.print("blocked ");
            }
            ThreadInfo thInfo = bean == null ? null : bean.getThreadInfo(t.getId());
            DiagnosticUtil.jvm5WriteLockInfo(thInfo, out);
            DiagnosticUtil.jvm5WriteThreadState(thInfo, out);
            out.println();
            for (StackTraceElement line : el) {
                out.println("    at " + line);
            }
            out.println();
        }
        out.println();
        DiagnosticUtil.printMemoryUsage(out);
    }

    private static void printMemoryUsage(Printer out) {
        out.println("Memory usage:");
        List<MemoryPoolMXBean> mpools = ManagementFactory.getMemoryPoolMXBeans();
        long totalUsed = 0L;
        long totalMax = 0L;
        String prefix = "   ";
        for (MemoryPoolMXBean pool : mpools) {
            MemoryUsage usage = pool.getUsage();
            StringBuilder line = new StringBuilder();
            line.append("   ").append(pool.getName()).append(": ");
            line.append("used = ").append(StringUtil.formatFileSize(usage.getUsed())).append(" ");
            line.append("committed = ").append(StringUtil.formatFileSize(usage.getCommitted())).append(" ");
            line.append("max = ").append(StringUtil.formatFileSize(usage.getMax())).append(" ");
            line.append(DiagnosticUtil.percent(usage.getUsed(), usage.getMax()));
            out.println(line.toString());
            totalUsed += usage.getUsed();
            totalMax += usage.getMax();
        }
        out.println("   Total: used = " + StringUtil.formatFileSize(totalUsed) + " max = " + StringUtil.formatFileSize(totalMax) + " " + DiagnosticUtil.percent(totalUsed, totalMax));
    }

    @NotNull
    public static MemoryUsage getHeapMemoryUsage() {
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memBean.getHeapMemoryUsage();
        if (memoryUsage == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/DiagnosticUtil.getHeapMemoryUsage must not return null");
        }
        return memoryUsage;
    }

    @Nullable
    public static MemoryUsage getPermGenPoolMemoryUsage() {
        for (MemoryPoolMXBean bean : DiagnosticUtil.getMemoryUsageBeans()) {
            if (!DiagnosticUtil.isPermGenPool(bean.getName())) continue;
            return bean.getUsage();
        }
        return null;
    }

    public static boolean isPermGenPool(String name) {
        return name.contains("Perm") || "class storage".equals(name);
    }

    public static List<MemoryPoolMXBean> getMemoryUsageBeans() {
        return ManagementFactory.getMemoryPoolMXBeans();
    }

    private static String percent(long used, long max) {
        String percentStr = "";
        if (max > 0L) {
            float percent = (float)((double)used * 100.0 / (double)max);
            percentStr = String.format("used/max = %.2f%%", Float.valueOf(percent));
        }
        return percentStr;
    }

    private static void printHeader(Printer out) {
        out.println(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Dates.now()));
        out.println(MessageFormat.format("Full thread dump {0} ({1} {2}):", System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("java.vm.info")));
        out.println();
    }

    private static ThreadMXBean getThreadsBean() {
        try {
            return ManagementFactory.getThreadMXBean();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void jvm5WriteLockInfo(ThreadInfo info, Printer ps) {
        if (info == null) {
            return;
        }
        String lock = info.getLockName();
        String lockOwner = info.getLockOwnerName();
        if (lock != null && lockOwner != null) {
            ps.println(MessageFormat.format("on {0}", lock));
            ps.print(MessageFormat.format("   by \"{0}\"", lockOwner));
        }
    }

    private static void jvm5WriteThreadState(ThreadInfo info, Printer ps) {
        if (info == null) {
            return;
        }
        Thread.State state = info.getThreadState();
        ps.println();
        ps.print("   java.lang.Thread.State: " + state.name());
    }

    public static boolean memoryDumpAvailable() {
        try {
            return DiagnosticUtil.getHotspotMBean() != null;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    @NotNull
    public static File memoryDump(@Nullable File hprofDir) throws Exception {
        File hprof = new File(hprofDir, "memoryDump-" + new SimpleDateFormat(FILE_DATE_FORMAT).format(Dates.now()) + ".hprof");
        Object mxbean = DiagnosticUtil.getHotspotMBean();
        if (mxbean == null) {
            throw new RuntimeException("Can't create HotSpotDiagnosticMXBean");
        }
        Method dumpHeap = mxbean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
        dumpHeap.invoke(mxbean, hprof.getAbsolutePath(), true);
        File file = hprof;
        if (file == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/DiagnosticUtil.memoryDump must not return null");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static File memoryDumpZipped(@Nullable File dir) throws Exception {
        File hprof = DiagnosticUtil.memoryDump(dir);
        File zippedHprof = new File(hprof.getAbsolutePath() + ".gz");
        BufferedInputStream fis = null;
        GZIPOutputStream os = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(hprof));
            os = new GZIPOutputStream(new FileOutputStream(zippedHprof));
            TCStreamUtil.writeBinary(fis, os);
        }
        catch (Throwable throwable) {
            FileUtil.close(os);
            FileUtil.close(fis);
            FileUtil.delete(hprof);
            throw throwable;
        }
        FileUtil.close(os);
        FileUtil.close(fis);
        FileUtil.delete(hprof);
        File file = zippedHprof;
        if (file == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/DiagnosticUtil.memoryDumpZipped must not return null");
        }
        return file;
    }

    @Nullable
    private static Object getHotspotMBean() throws UnsupportedOperationException {
        try {
            final Class<?> hotSpotMxBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    Set<ObjectName> s = server.queryNames(new ObjectName(DiagnosticUtil.HOTSPOT_BEAN_NAME), null);
                    Iterator<ObjectName> itr = s.iterator();
                    if (itr.hasNext()) {
                        ObjectName name = itr.next();
                        return ManagementFactory.newPlatformMXBeanProxy(server, name.toString(), hotSpotMxBeanClass);
                    }
                    return null;
                }
            });
        }
        catch (Exception exp) {
            throw new UnsupportedOperationException(exp);
        }
    }

    private static interface Printer {
        public void println(@NotNull String var1);

        public void println();

        public void print(@NotNull String var1);
    }
}

