/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.ELFReader;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jetbrains.buildServer.util.ELFReader.ElfClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElfUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ElfClass getClass(@NotNull File elfFile) {
        if (elfFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ELFReader/ElfUtil.getClass must not be null");
        }
        RandomAccessFile raf = null;
        try {
            byte[] buf = new byte[5];
            raf = new RandomAccessFile(elfFile, "r");
            if (raf.read(buf) != buf.length) {
                ElfClass elfClass = null;
                return elfClass;
            }
            if (buf[1] != 69 || buf[2] != 76 || buf[3] != 70) {
                ElfClass elfClass = null;
                return elfClass;
            }
            switch (buf[4]) {
                case 1: {
                    ElfClass elfClass = ElfClass.ELFCLASS32;
                    return elfClass;
                }
                case 2: {
                    ElfClass elfClass = ElfClass.ELFCLASS64;
                    return elfClass;
                }
            }
            ElfClass elfClass = ElfClass.ELFCLASSNONE;
            return elfClass;
        }
        catch (Exception e) {
            ElfClass elfClass = null;
            return elfClass;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

