/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.buildServer.util.NamedThreadUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NamedThreadFactory
implements ThreadFactory {
    @NonNls
    private static final String EOL = System.getProperty("line.separator");
    private final AtomicInteger myCounter = new AtomicInteger(1);
    private final String myName;
    private final Map<Thread, Boolean> myThreads = new ConcurrentHashMap<Thread, Boolean>();

    public NamedThreadFactory(String name) {
        this.myName = name;
    }

    @Deprecated
    public static String updateThreadName(@NotNull String newDetails) {
        if (newDetails == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/NamedThreadFactory.updateThreadName must not be null");
        }
        return NamedThreadUtil.updateThreadName(newDetails).getOldName();
    }

    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/NamedThreadFactory.newThread must not be null");
        }
        this.cleanInactive();
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setName(this.myName + " " + this.myCounter.getAndIncrement());
        this.myThreads.put(thread, Boolean.TRUE);
        Thread thread2 = thread;
        if (thread2 == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/NamedThreadFactory.newThread must not return null");
        }
        return thread2;
    }

    public String getThreadDump() {
        this.cleanInactive();
        StringBuilder sb = new StringBuilder();
        for (Thread thread : this.myThreads.keySet()) {
            NamedThreadFactory.appendThreadStacktrace(sb, thread);
        }
        NamedThreadFactory.appendThreadStacktrace(sb, Thread.currentThread());
        sb.append(EOL);
        return sb.toString();
    }

    private static void appendThreadStacktrace(StringBuilder sb, Thread thread) {
        StackTraceElement[] trace;
        sb.append(thread.getName()).append(EOL);
        for (StackTraceElement aTrace : trace = thread.getStackTrace()) {
            sb.append("\tat ").append(aTrace).append(EOL);
        }
    }

    private void cleanInactive() {
        for (Thread thread : new HashSet<Thread>(this.myThreads.keySet())) {
            if (thread.isAlive()) continue;
            this.myThreads.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeWithNewThreadName(@NotNull String newDetails, @NotNull Runnable action) {
        if (newDetails == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/NamedThreadFactory.executeWithNewThreadName must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/NamedThreadFactory.executeWithNewThreadName must not be null");
        }
        NamedThreadUtil.ThreadNameCookie cookie = NamedThreadUtil.updateThreadName(newDetails);
        try {
            action.run();
        }
        finally {
            cookie.dispose();
        }
    }
}

