/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.Calendar;
import org.jetbrains.annotations.NotNull;

public class NamedThreadUtil {
    private static final String tc_prefix = "TC: ";

    @NotNull
    public static ThreadNameCookie updateThreadName(@NotNull String newDetails) {
        if (newDetails == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/NamedThreadUtil.updateThreadName must not be null");
        }
        ThreadNameCookie threadNameCookie = new ThreadNameCookie().setNewName(newDetails);
        if (threadNameCookie == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/NamedThreadUtil.updateThreadName must not return null");
        }
        return threadNameCookie;
    }

    public static final class ThreadNameCookie {
        private final Thread myThread = Thread.currentThread();
        private final String myOldMessage;

        private ThreadNameCookie() {
            String message = this.myThread.getName();
            if (message == null) {
                message = "";
            }
            this.myOldMessage = message;
        }

        @NotNull
        public String getOldName() {
            String string = this.myOldMessage;
            if (string == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/NamedThreadUtil$ThreadNameCookie.getOldName must not return null");
            }
            return string;
        }

        @NotNull
        public ThreadNameCookie setNewName(@NotNull String newDetails) {
            if (newDetails == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/NamedThreadUtil$ThreadNameCookie.setNewName must not be null");
            }
            String currentName = this.getOldName();
            String namePrefix = NamedThreadUtil.tc_prefix + ThreadNameCookie.time_prefix() + newDetails + "; ";
            if (currentName.startsWith(NamedThreadUtil.tc_prefix)) {
                this.myThread.setName(namePrefix + currentName.substring(NamedThreadUtil.tc_prefix.length()));
            } else {
                this.myThread.setName(namePrefix + currentName);
            }
            ThreadNameCookie threadNameCookie = this;
            if (threadNameCookie == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/NamedThreadUtil$ThreadNameCookie.setNewName must not return null");
            }
            return threadNameCookie;
        }

        public void dispose() {
            this.myThread.setName(this.myOldMessage);
        }

        @NotNull
        private static String time_prefix() {
            Calendar c = Calendar.getInstance();
            int hour = c.get(11);
            int min = c.get(12);
            int sec = c.get(13);
            StringBuilder sb = new StringBuilder();
            if (hour < 10) {
                sb.append('0');
            }
            sb.append(hour).append(':');
            if (min < 10) {
                sb.append('0');
            }
            sb.append(min).append(':');
            if (sec < 10) {
                sb.append('0');
            }
            sb.append(sec).append(' ');
            String string = sb.toString();
            if (string == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/NamedThreadUtil$ThreadNameCookie.time_prefix must not return null");
            }
            return string;
        }
    }
}

