/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.PEReader;

import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import jetbrains.buildServer.util.PEReader.PEImageDosHeader;
import jetbrains.buildServer.util.PEReader.PEImageFileHeader;
import jetbrains.buildServer.util.PEReader.PEImageOptionalHeader;
import jetbrains.buildServer.util.PEReader.PEImageResourceDataEntry;
import jetbrains.buildServer.util.PEReader.PEImageResourceDirectory;
import jetbrains.buildServer.util.PEReader.PEImageResourceDirectoryEntry;
import jetbrains.buildServer.util.PEReader.PEImageSectionHeader;
import jetbrains.buildServer.util.PEReader.PEVersion;
import jetbrains.buildServer.util.PEReader.PEVsFixedFileInfo;
import jetbrains.buildServer.util.PEReader.PEVsVersionInfo;
import jetbrains.buildServer.util.PEReader.ResourceEntryVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEReader
implements Closeable {
    private final RandomAccessFile myFile;
    private final PEImageDosHeader myDosHeader;
    private final PEImageFileHeader myFileHeader;
    private final PEImageOptionalHeader myOptionalHeader;
    private final PEImageSectionHeader[] mySections;

    public PEReader(RandomAccessFile file) throws IOException {
        this.myFile = file;
        this.myDosHeader = PEImageDosHeader.read(this.myFile);
        this.myFile.seek(this.myDosHeader.getPEHeaderOffset());
        this.myFileHeader = PEImageFileHeader.read(this.myFile);
        this.myOptionalHeader = PEImageOptionalHeader.read(this.myFile);
        this.mySections = new PEImageSectionHeader[this.myFileHeader.getNumberOfSections()];
        for (int i = 0; i < this.myFileHeader.getNumberOfSections(); ++i) {
            this.mySections[i] = PEImageSectionHeader.read(this.myFile);
        }
    }

    @Override
    public void close() throws IOException {
        this.myFile.close();
    }

    public long getResourcesBase() {
        long rva = this.myOptionalHeader.getDataDirectories()[2].getVirtualAddress();
        if (rva == 0L) {
            return 0L;
        }
        return this.rvaToOffset(rva);
    }

    public long rvaToOffset(long rva) {
        for (PEImageSectionHeader sectionHeader : this.mySections) {
            if (sectionHeader.getVirtualAddress() > rva || rva >= sectionHeader.getVirtualAddress() + sectionHeader.getSizeOfRawData()) continue;
            return sectionHeader.getPointerToRawData() + (rva - sectionHeader.getVirtualAddress());
        }
        throw new IllegalArgumentException("Invalid RVA " + rva);
    }

    public void visitResourceEntries(ResourceEntryVisitor visitor) throws IOException {
        long resourcesBase = this.getResourcesBase();
        if (resourcesBase == 0L) {
            return;
        }
        HashSet<Long> visitedRoots = new HashSet<Long>();
        Stack<PEImageResourceDirectoryEntry> path = new Stack<PEImageResourceDirectoryEntry>();
        this.visitResourceEntriesRec(visitor, resourcesBase, 0L, visitedRoots, path);
    }

    private PEVsFixedFileInfo getFixedFileInfo() throws IOException {
        final Vector versionEntries = new Vector();
        this.visitResourceEntries(new ResourceEntryVisitor(){

            @Override
            public void visit(Stack<PEImageResourceDirectoryEntry> path) {
                if (path.size() != 3) {
                    return;
                }
                if (((PEImageResourceDirectoryEntry)path.get(0)).getId() == 16) {
                    versionEntries.add(path.peek());
                }
            }
        });
        if (versionEntries.size() == 0) {
            return null;
        }
        PEImageResourceDirectoryEntry versionEntry = (PEImageResourceDirectoryEntry)versionEntries.get(0);
        this.myFile.seek(versionEntry.getOffsetToData() + this.getResourcesBase());
        PEImageResourceDataEntry versionEntryData = PEImageResourceDataEntry.read(this.myFile);
        long versionInfoOffset = this.rvaToOffset(versionEntryData.getOffsetToData());
        this.myFile.seek(versionInfoOffset);
        PEVsVersionInfo versionInfo = PEVsVersionInfo.read(this.myFile);
        return versionInfo.getFixedFileInfo();
    }

    public PEImageOptionalHeader getOptionalHeader() {
        return this.myOptionalHeader;
    }

    public PEVersion getProductVersion() throws IOException {
        PEVsFixedFileInfo fixedFileInfo = this.getFixedFileInfo();
        return new PEVersion(fixedFileInfo.getProductVersion1(), fixedFileInfo.getProductVersion2(), fixedFileInfo.getProductVersion3(), fixedFileInfo.getProductVersion4());
    }

    public PEVersion getFileVersion() throws IOException {
        PEVsFixedFileInfo fixedFileInfo = this.getFixedFileInfo();
        return new PEVersion(fixedFileInfo.getFileVersion1(), fixedFileInfo.getFileVersion2(), fixedFileInfo.getFileVersion3(), fixedFileInfo.getFileVersion4());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitResourceEntriesRec(ResourceEntryVisitor visitor, long resourcesBase, long rootDelta, Set<Long> visitedRoots, Stack<PEImageResourceDirectoryEntry> path) throws IOException {
        if (visitedRoots.contains(rootDelta)) {
            return;
        }
        visitedRoots.add(rootDelta);
        this.myFile.seek(resourcesBase + rootDelta);
        PEImageResourceDirectory dir = PEImageResourceDirectory.read(this.myFile);
        for (PEImageResourceDirectoryEntry entry : dir.getEntries()) {
            path.push(entry);
            try {
                if (entry.isDirectory()) {
                    this.visitResourceEntriesRec(visitor, resourcesBase, entry.getOffsetToDirectory(), visitedRoots, path);
                    continue;
                }
                visitor.visit(path);
            }
            finally {
                path.pop();
            }
        }
    }
}

