/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLRUMap<K, V>
implements Map<K, V> {
    protected final LinkedHashMap<K, V> myProtectedQueue;
    protected final LinkedHashMap<K, V> myProbationalQueue;
    private final int myProtectedQueueSize;
    private final int myProbationalQueueSize;
    private int probationalHits = 0;
    private int protectedHits = 0;
    private int misses = 0;

    public SLRUMap(int protectedQueueSize, int probationalQueueSize) {
        this.myProtectedQueueSize = protectedQueueSize;
        this.myProbationalQueueSize = probationalQueueSize;
        this.myProtectedQueue = new LinkedHashMap<K, V>(10, 0.8f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                if (this.size() > SLRUMap.this.myProtectedQueueSize) {
                    SLRUMap.this.myProbationalQueue.put(eldest.getKey(), eldest.getValue());
                    return true;
                }
                return false;
            }
        };
        this.myProbationalQueue = new LinkedHashMap<K, V>(10, 0.8f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > SLRUMap.this.myProbationalQueueSize;
            }
        };
    }

    @Override
    @Nullable
    public V get(Object key) {
        V value = this.myProtectedQueue.get(key);
        if (value != null) {
            ++this.protectedHits;
            return value;
        }
        value = this.myProbationalQueue.remove(key);
        if (value != null) {
            ++this.probationalHits;
            this.myProtectedQueue.put(key, value);
            return value;
        }
        ++this.misses;
        return null;
    }

    @Override
    public int size() {
        return this.myProtectedQueue.size() + this.myProbationalQueue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myProtectedQueue.isEmpty() && this.myProbationalQueue.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.myProbationalQueue.containsKey(key) || this.myProtectedQueue.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myProbationalQueue.containsValue(value) || this.myProtectedQueue.containsValue(value);
    }

    @Override
    @Nullable
    public V put(K key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/SLRUMap.put must not be null");
        }
        Object removed1 = this.myProtectedQueue.remove(key);
        V removed2 = this.myProbationalQueue.put(key, value);
        return removed1 != null ? removed1 : removed2;
    }

    @Override
    public V remove(Object key) {
        Object value = this.myProtectedQueue.remove(key);
        if (value != null) {
            return value;
        }
        return this.myProbationalQueue.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>(this.myProtectedQueue.entrySet());
        set.addAll(this.myProbationalQueue.entrySet());
        HashSet<Map.Entry<K, V>> hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/SLRUMap.entrySet must not return null");
        }
        return hashSet;
    }

    @Override
    public void clear() {
        this.myProtectedQueue.clear();
        this.myProbationalQueue.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        HashSet<K> keys = new HashSet<K>(this.myProtectedQueue.keySet());
        keys.addAll(this.myProbationalQueue.keySet());
        HashSet<K> hashSet = keys;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/SLRUMap.keySet must not return null");
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>(this.myProtectedQueue.values());
        values.addAll(this.myProbationalQueue.values());
        ArrayList<V> arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/SLRUMap.values must not return null");
        }
        return arrayList;
    }

    public float getHitRate() {
        int total = this.misses + this.probationalHits + this.protectedHits;
        System.out.println("Total: " + total + ", probationalHits: " + this.probationalHits + ", protectedHits: " + this.protectedHits);
        return 1.0f * (float)(this.probationalHits + this.protectedHits) / (float)total;
    }
}

