/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftCache<T> {
    private final Calculator<T> myCalculator;
    private volatile SoftReference<T> myRef;

    public SoftCache(@NotNull Calculator<T> calculator) {
        if (calculator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/SoftCache.<init> must not be null");
        }
        this.myCalculator = calculator;
    }

    @Nullable
    private T getCached() {
        T t;
        SoftReference<T> ref = this.myRef;
        if (ref != null && (t = ref.get()) != null) {
            return t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T get() {
        T t = this.getCached();
        if (t != null) {
            return t;
        }
        SoftCache softCache = this;
        synchronized (softCache) {
            t = this.getCached();
            if (t != null) {
                return t;
            }
            t = this.myCalculator.compute();
            if (t != null) {
                this.myRef = new SoftReference<T>(t);
            }
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Calculator<T> {
        @Nullable
        public T compute();
    }
}

