/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SynchroDictionary<K, V> {
    @NotNull
    private final Function<K, V> myDataProvider;
    @NotNull
    private final ConcurrentHashMap<K, Object> myLocks;
    @NotNull
    private final ConcurrentHashMap<K, V> myObjects;
    @NotNull
    private final ReadWriteLock myGlobalLock;

    public SynchroDictionary(@NotNull Function<K, V> dataProvider) {
        if (dataProvider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/SynchroDictionary.<init> must not be null");
        }
        this.myLocks = new ConcurrentHashMap();
        this.myObjects = new ConcurrentHashMap();
        this.myGlobalLock = new ReentrantReadWriteLock(true);
        this.myDataProvider = dataProvider;
    }

    public boolean containsKey(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/SynchroDictionary.containsKey must not be null");
        }
        return this.myObjects.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/SynchroDictionary.get must not be null");
        }
        V value = this.myObjects.get(key);
        if (value == null) {
            Object lock = this.getLock(key);
            this.myGlobalLock.readLock().lock();
            try {
                Object object = lock;
                synchronized (object) {
                    value = this.myObjects.get(key);
                    if (value == null && (value = this.myDataProvider.apply(key)) != null) {
                        this.myObjects.put(key, value);
                    }
                }
            }
            finally {
                this.myGlobalLock.readLock().unlock();
            }
        }
        return value;
    }

    @NotNull
    private Object getLock(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/SynchroDictionary.getLock must not be null");
        }
        Object lock = this.myLocks.get(key);
        if (lock == null) {
            this.myLocks.putIfAbsent(key, new Object());
            lock = this.myLocks.get(key);
            assert (lock != null);
        }
        Object object = lock;
        if (object == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/SynchroDictionary.getLock must not return null");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/SynchroDictionary.invalidate must not be null");
        }
        Object lock = this.getLock(key);
        this.myGlobalLock.readLock().lock();
        try {
            Object object = lock;
            synchronized (object) {
                this.myObjects.remove(key);
                this.myLocks.remove(key);
            }
        }
        finally {
            this.myGlobalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll() {
        this.myGlobalLock.writeLock().lock();
        try {
            this.myObjects.clear();
            this.myLocks.clear();
        }
        finally {
            this.myGlobalLock.writeLock().unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Function<K, V> {
        @Nullable
        public V apply(@NotNull K var1);
    }
}

