/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NonNls;

public class TCLineReader {
    private int myPos = -1;
    private int[] myBuffer = new int[2];
    private final InputStream myInputStream;
    private final OutputStream myOutput;
    private final byte[] myNewSeparator;
    private boolean myAtEnd = false;
    private final long myLength;
    private int myRead;
    private final ReadLine myReadLine;

    public TCLineReader(InputStream in, long length, OutputStream output, byte[] newSeparator) throws IOException {
        this.myInputStream = in;
        this.myOutput = output;
        this.myNewSeparator = newSeparator;
        this.myRead = 0;
        this.myLength = length;
        this.myReadLine = new ReadLine();
    }

    public void writeUsingNewSeparator() throws IOException {
        boolean notFinished;
        boolean first = true;
        while (notFinished = this.myReadLine.copyNextLine(this.myOutput, this.myNewSeparator, first)) {
            first = false;
        }
    }

    private int read() throws IOException {
        if (this.myPos >= 0) {
            int result = this.myBuffer[this.myPos];
            --this.myPos;
            return result;
        }
        if ((long)this.myRead == this.myLength) {
            return -1;
        }
        int result = this.myInputStream.read();
        if (result != -1) {
            ++this.myRead;
        }
        return result;
    }

    private void unread(int b) throws IOException {
        ++this.myPos;
        if (this.myPos >= this.myBuffer.length) {
            throw new IOException("Push back buffer is full");
        }
        this.myBuffer[this.myPos] = b;
    }

    private class ReadLine {
        @NonNls
        private static final String NL_RR = "\r\r";
        @NonNls
        private static final String NL_R = "\r";

        private ReadLine() {
        }

        private boolean notLineSeparator(int ch) {
            return ch != 13 && ch != 10;
        }

        public boolean copyNextLine(OutputStream output, byte[] newSeparator, boolean first) throws IOException {
            if (TCLineReader.this.myAtEnd) {
                return false;
            }
            if (!first) {
                output.write(newSeparator);
            }
            String currentEOL = "";
            while (true) {
                int ch;
                if ((ch = TCLineReader.this.read()) == -1) {
                    if (currentEOL.length() > 0) {
                        output.write(newSeparator);
                    }
                    TCLineReader.this.myAtEnd = true;
                    return false;
                }
                if (this.notLineSeparator(ch)) {
                    if (currentEOL.equals(NL_R)) {
                        TCLineReader.this.unread(ch);
                        return true;
                    }
                    if (currentEOL.equals(NL_RR)) {
                        TCLineReader.this.unread(ch);
                        TCLineReader.this.unread(13);
                        return true;
                    }
                    output.write(ch);
                    continue;
                }
                if (ch == 13) {
                    if (currentEOL.length() == 0 || currentEOL.equals(NL_R)) {
                        currentEOL = currentEOL + NL_R;
                        continue;
                    }
                    if (!currentEOL.equals(NL_RR)) continue;
                    TCLineReader.this.unread(13);
                    TCLineReader.this.unread(13);
                    return true;
                }
                if (ch == 10) break;
            }
            return true;
        }
    }
}

