/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.util.SystemInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.vcs.patches.PatchStreamUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TCStreamUtil {
    public static void skip(@NotNull InputStream input, long size) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/TCStreamUtil.skip must not be null");
        }
        PatchStreamUtil.skip(input, size);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeBinary(@NotNull InputStream input, long length, @NotNull OutputStream outputStream) throws IOException {
        void output;
        if (input == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/TCStreamUtil.writeBinary must not be null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/TCStreamUtil.writeBinary must not be null");
        }
        PatchStreamUtil.writeBinary(input, length, (OutputStream)output);
    }

    private static byte[] getByteBuffer() {
        return new byte[8192];
    }

    public static void writeBinary(InputStream input, OutputStream output) throws IOException {
        TCStreamUtil.writeBinary(input, output, null, 0L);
    }

    public static void writeBinary(@NotNull InputStream input, @NotNull OutputStream output, @Nullable WriteProgressListener listener, long minProgressIntervalMillis) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/TCStreamUtil.writeBinary must not be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/TCStreamUtil.writeBinary must not be null");
        }
        byte[] buffer = TCStreamUtil.getByteBuffer();
        long totalRead = 0L;
        long reportedTime = System.currentTimeMillis();
        int read = 0;
        while (read != -1) {
            read = input.read(buffer, 0, buffer.length);
            if (read == -1) continue;
            output.write(buffer, 0, read);
            if (listener == null) continue;
            if (listener.isInterrupted()) {
                throw new InterruptedIOException();
            }
            totalRead += (long)read;
            long currentTime = System.currentTimeMillis();
            if (currentTime - reportedTime < minProgressIntervalMillis) continue;
            listener.nextPortionWritten(totalRead, false);
            reportedTime = currentTime;
        }
        if (listener != null) {
            listener.nextPortionWritten(totalRead, true);
        }
    }

    public static boolean setFileMode(@Nullable File file, @NotNull String mode) throws IOException {
        if (mode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/TCStreamUtil.setFileMode must not be null");
        }
        if (SystemInfo.isWindows || file == null || !file.exists()) {
            return true;
        }
        try {
            return TCStreamUtil.execCommand(new String[]{"chmod", mode, file.getAbsolutePath()});
        }
        catch (Throwable th) {
            throw new IOException(th.getLocalizedMessage());
        }
    }

    private static boolean execCommand(String[] commandLine) throws Exception {
        Process process = Runtime.getRuntime().exec(commandLine);
        FileUtil.closeAll(process.getErrorStream(), process.getInputStream(), process.getOutputStream());
        return process.waitFor() == 0;
    }

    @Nullable
    public static String readString(@NotNull DataInputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/TCStreamUtil.readString must not be null");
        }
        int length = input.readInt();
        if (length == -1) {
            return null;
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = input.readChar();
        }
        return new String(chars);
    }

    public static void writeString(@NotNull DataOutputStream outputStream, @NotNull String string) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/TCStreamUtil.writeString must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/TCStreamUtil.writeString must not be null");
        }
        outputStream.writeInt(string.length());
        for (int i = 0; i < string.length(); ++i) {
            outputStream.writeChar(string.charAt(i));
        }
    }

    public static interface WriteProgressListener {
        public void nextPortionWritten(long var1, boolean var3);

        public boolean isInterrupted();
    }
}

