/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jetbrains.buildServer.util.FuncThrow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    @Nullable
    public static <T extends Comparable> T max(@Nullable T o1, @Nullable T o2) {
        if (o1 == null && o2 == null) {
            return null;
        }
        if (o1 == null) {
            return o2;
        }
        if (o2 == null) {
            return o1;
        }
        return o1.compareTo(o2) >= 0 ? o1 : o2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T doUnderContextClassLoader(@NotNull ClassLoader cl, FuncThrow<T, E> action) throws E {
        if (cl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/Util.doUnderContextClassLoader must not be null");
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            T t = action.apply();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public static <T> Map<T, T> map(T ... args) {
        LinkedHashMap<T, Object> result = new LinkedHashMap<T, Object>();
        int i = 0;
        while (i < args.length) {
            T key = args[i++];
            Object val = i < args.length ? (Object)args[i++] : null;
            result.put(key, val);
        }
        return Collections.unmodifiableMap(result);
    }

    @Nullable
    public static <T extends Throwable> T unwrapCause(@Nullable Throwable t, @NotNull Class<T> causeClass) {
        if (causeClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/Util.unwrapCause must not be null");
        }
        if (t == null) {
            return null;
        }
        if (causeClass.isInstance(t)) {
            return (T)((Throwable)causeClass.cast(t));
        }
        return Util.unwrapCause(t.getCause(), causeClass);
    }
}

