/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedFilter<T>
implements Filter<T> {
    @NotNull
    private final List<Filter<? super T>> myDelegates;

    public AggregatedFilter(Filter<? super T> ... delegates) {
        if (delegates == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/filters/AggregatedFilter.<init> must not be null");
        }
        this.myDelegates = new ArrayList<Filter<? super T>>();
        this.myDelegates.addAll(Arrays.asList(delegates));
    }

    public AggregatedFilter(@NotNull List<Filter<? super T>> delegates) {
        if (delegates == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/filters/AggregatedFilter.<init> must not be null");
        }
        this.myDelegates = new ArrayList<Filter<? super T>>();
        this.myDelegates.addAll(delegates);
    }

    @Override
    public boolean accept(@NotNull T data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/filters/AggregatedFilter.accept must not be null");
        }
        for (Filter<T> delegate : this.myDelegates) {
            if (delegate == null || delegate.accept(data)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Filter<? super T> filter : this.myDelegates) {
            if (!isFirst) {
                sb.append(" & ");
            } else {
                isFirst = false;
            }
            sb.append(filter);
        }
        return sb.toString();
    }
}

