/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.positioning;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PositionConstraint {
    public static final PositionConstraint UNDEFINED = new PositionConstraint(){

        public String toString() {
            return "undefined";
        }

        public int compareTo(String id) {
            return 0;
        }
    };
    private static final PositionConstraint FIRST = new PositionConstraint(){

        public int compareTo(String id) {
            return Integer.MIN_VALUE;
        }

        public String toString() {
            return "first";
        }
    };
    private static final PositionConstraint LAST = new PositionConstraint(){

        public int compareTo(String id) {
            return Integer.MAX_VALUE;
        }

        public String toString() {
            return "last";
        }
    };

    @NotNull
    public static PositionConstraint first() {
        PositionConstraint positionConstraint = FIRST;
        if (positionConstraint == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionConstraint.first must not return null");
        }
        return positionConstraint;
    }

    @NotNull
    public static PositionConstraint last() {
        PositionConstraint positionConstraint = LAST;
        if (positionConstraint == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionConstraint.last must not return null");
        }
        return positionConstraint;
    }

    public boolean isFirst() {
        return this == FIRST;
    }

    public boolean isLast() {
        return this == LAST;
    }

    @NotNull
    public Collection<String> getBefore() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionConstraint.getBefore must not return null");
        }
        return list;
    }

    @NotNull
    public Collection<String> getAfter() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionConstraint.getAfter must not return null");
        }
        return list;
    }

    @NotNull
    public static PositionConstraint before(final String ... ids) {
        if (ids == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionConstraint.before must not be null");
        }
        final HashSet<String> idSet = new HashSet<String>(Arrays.asList(ids));
        PositionConstraint positionConstraint = new PositionConstraint(){

            @Override
            public int compareTo(String id) {
                if (idSet.contains(id)) {
                    return -1;
                }
                return 0;
            }

            @Override
            public String toString() {
                return "before: " + Arrays.asList(ids);
            }

            @Override
            @NotNull
            public Collection<String> getBefore() {
                Set set = idSet;
                if (set == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionConstraint$1.getBefore must not return null");
                }
                return set;
            }
        };
        if (positionConstraint == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionConstraint.before must not return null");
        }
        return positionConstraint;
    }

    @NotNull
    public static PositionConstraint after(final String ... ids) {
        if (ids == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionConstraint.after must not be null");
        }
        final HashSet<String> idSet = new HashSet<String>(Arrays.asList(ids));
        PositionConstraint positionConstraint = new PositionConstraint(){

            @Override
            public int compareTo(String id) {
                if (idSet.contains(id)) {
                    return 1;
                }
                return 0;
            }

            @Override
            public String toString() {
                return "after: " + Arrays.asList(ids);
            }

            @Override
            @NotNull
            public Collection<String> getAfter() {
                Set set = idSet;
                if (set == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionConstraint$2.getAfter must not return null");
                }
                return set;
            }
        };
        if (positionConstraint == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionConstraint.after must not return null");
        }
        return positionConstraint;
    }

    @NotNull
    public static PositionConstraint between(@NotNull Collection<String> afterIds, @NotNull Collection<String> beforeIds) {
        if (afterIds == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionConstraint.between must not be null");
        }
        if (beforeIds == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionConstraint.between must not be null");
        }
        final PositionConstraint beforePos = PositionConstraint.before(beforeIds.toArray(new String[beforeIds.size()]));
        final PositionConstraint afterPos = PositionConstraint.after(afterIds.toArray(new String[afterIds.size()]));
        PositionConstraint positionConstraint = new PositionConstraint(){

            @Override
            public String toString() {
                return beforePos.toString() + " and " + afterPos.toString();
            }

            @Override
            public int compareTo(String id) {
                int res = beforePos.compareTo(id);
                if (res != 0) {
                    return res;
                }
                return afterPos.compareTo(id);
            }

            @Override
            @NotNull
            public Collection<String> getAfter() {
                Collection<String> collection = afterPos.getAfter();
                if (collection == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionConstraint$3.getAfter must not return null");
                }
                return collection;
            }

            @Override
            @NotNull
            public Collection<String> getBefore() {
                Collection<String> collection = beforePos.getBefore();
                if (collection == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionConstraint$3.getBefore must not return null");
                }
                return collection;
            }
        };
        if (positionConstraint == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionConstraint.between must not return null");
        }
        return positionConstraint;
    }

    public abstract String toString();

    public abstract int compareTo(String var1);
}

