/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TCStringUtil;
import jetbrains.buildServer.vcs.FileRuleSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRule<ParentRules extends FileRuleSet> {
    protected final String myFromPath;
    protected final String myFromFull;
    private final ParentRules myParentRules;
    protected final Pattern myPattern;
    private final boolean myIsInclude;
    private static final String STANDARD_TAIL = "(\\/.*)*";
    private Map<String, String> myAdditionalProperties;

    public FileRule(String from, ParentRules parentRules, boolean isInclude) {
        this(from, parentRules, isInclude, true);
    }

    public FileRule(String from, ParentRules parentRules, boolean isInclude, boolean usePattern) {
        String fromPath;
        this.myFromFull = StringUtil.emptyIfNull(from);
        if (from.contains(":")) {
            from = this.readAdditionalProperties(from);
        }
        if ((fromPath = FileRule.prepareRulePath(from)).equals(this.myFromFull)) {
            fromPath = this.myFromFull;
        }
        this.myFromPath = StringUtil.emptyIfNull(fromPath);
        this.myParentRules = parentRules;
        this.myIsInclude = isInclude;
        this.myPattern = usePattern ? this.compilePattern() : null;
    }

    @Nullable
    private Pattern compilePattern() {
        if (this.myFromPath.endsWith("*") || this.myFromPath.endsWith("**")) {
            return Pattern.compile(this.createPatternString(this.myFromPath));
        }
        if (this.myFromPath.length() == 0) {
            return null;
        }
        return Pattern.compile(this.createPatternString(this.myFromPath) + STANDARD_TAIL);
    }

    public FileRule(@NotNull String fromPath, @Nullable String additionalProperties, @NotNull ParentRules parentRules, boolean isInclude) {
        if (fromPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/FileRule.<init> must not be null");
        }
        if (parentRules == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/vcs/FileRule.<init> must not be null");
        }
        this.myFromPath = FileRule.prepareRulePath(fromPath);
        this.myFromFull = fromPath + (additionalProperties == null ? "" : ":" + additionalProperties);
        this.myParentRules = parentRules;
        this.myIsInclude = isInclude;
        this.myPattern = this.compilePattern();
    }

    @NotNull
    private String readAdditionalProperties(@NotNull String from) {
        if (from == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/FileRule.readAdditionalProperties must not be null");
        }
        int lastSeparator = from.lastIndexOf(":");
        String properties = from.substring(0, lastSeparator);
        this.myAdditionalProperties = TCStringUtil.readProperties(properties, ";", "=");
        String string = from.substring(lastSeparator + 1);
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/FileRule.readAdditionalProperties must not return null");
        }
        return string;
    }

    @NotNull
    protected static String prepareRulePath(@Nullable String path) {
        if (path == null || path.length() == 0) {
            if ("" == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/FileRule.prepareRulePath must not return null");
            }
            return "";
        }
        String string = FileUtil.normalizeRelativePath(path);
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/FileRule.prepareRulePath must not return null");
        }
        return string;
    }

    @NotNull
    protected String createPatternString(@NotNull String from) {
        if (from == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/FileRule.createPatternString must not be null");
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < from.length(); ++i) {
            char nextChar = from.charAt(i);
            if (nextChar == '\\') {
                result.append("\\/");
                continue;
            }
            if (nextChar == '?') {
                result.append(".");
                continue;
            }
            if (nextChar == '$' || nextChar == '(' || nextChar == '{' || nextChar == ')' || nextChar == '}' || nextChar == '[' || nextChar == ']' || nextChar == '/' || nextChar == '.' || nextChar == '+') {
                result.append("\\").append(nextChar);
                continue;
            }
            if (nextChar == '*') {
                if (i < from.length() - 1 && from.charAt(i + 1) == '*') {
                    result.append("(.*)");
                    ++i;
                    continue;
                }
                result.append("([^/]*)");
                continue;
            }
            result.append(nextChar);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/FileRule.createPatternString must not return null");
        }
        return string;
    }

    public String getFrom() {
        return this.myFromPath;
    }

    public ParentRules getParentRules() {
        return this.myParentRules;
    }

    public boolean isIsInclude() {
        return this.myIsInclude;
    }

    public String toString() {
        if (this.myIsInclude) {
            return this.myFromFull;
        }
        return "-:" + this.myFromFull;
    }

    @Nullable
    public String getMatchedHead(String path) {
        if (this.myPattern == null) {
            return "";
        }
        Matcher matcher = this.myPattern.matcher(path);
        if (matcher.matches()) {
            int groupCount = matcher.groupCount();
            String lastGroup = matcher.group(groupCount);
            if (lastGroup != null) {
                return FileRule.prepareRulePath(path.substring(0, path.length() - lastGroup.length()));
            }
            return FileRule.prepareRulePath(path);
        }
        return null;
    }

    @Nullable
    public String getProperty(String propName) {
        if (this.myAdditionalProperties == null) {
            return null;
        }
        return this.myAdditionalProperties.get(propName);
    }

    public boolean propertiesMatch(Map<String, String> props) {
        if (this.myAdditionalProperties == null) {
            return true;
        }
        for (String name : this.myAdditionalProperties.keySet()) {
            String expectedProp = this.myAdditionalProperties.get(name);
            String actualProp = props.get(name);
            if (expectedProp == null || expectedProp.equals(actualProp)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Map<String, String> getAdditionalProperties() {
        return this.myAdditionalProperties;
    }

    public boolean isAbsolutePath() {
        return this.myFromFull.startsWith("/");
    }

    public boolean isRoot() {
        return StringUtil.isEmpty((String)this.myFromPath) && (this.myAdditionalProperties == null || this.myAdditionalProperties.isEmpty());
    }
}

