/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.util.PropertiesUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.filters.FilterUtil;
import jetbrains.buildServer.vcs.FileRule;
import jetbrains.buildServer.vcs.IncludeRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileRuleSet<IncludeRuleClass extends FileRule, ExcludeRuleClass extends FileRule> {
    private final List<String> myBody;
    private final List<IncludeRuleClass> myIncludeRules;
    private final List<ExcludeRuleClass> myExcludeRules;

    public FileRuleSet(@NotNull List<String> body) {
        if (body == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/FileRuleSet.<init> must not be null");
        }
        this.myBody = FileRuleSet.trimLines(body);
        this.myIncludeRules = new ArrayList<IncludeRuleClass>(0);
        this.myExcludeRules = new ArrayList<ExcludeRuleClass>(0);
        this.init(this.myBody);
    }

    public FileRuleSet(@NotNull String body) {
        if (body == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/FileRuleSet.<init> must not be null");
        }
        this(FileRuleSet.readLines(body));
    }

    @NotNull
    private static List<String> trimLines(@NotNull List<String> body) {
        if (body == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/FileRuleSet.trimLines must not be null");
        }
        ArrayList<String> result = new ArrayList<String>(0);
        for (String line : body) {
            String trimmed = line.trim();
            if (trimmed.length() <= 0) continue;
            result.add(trimmed);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/FileRuleSet.trimLines must not return null");
        }
        return arrayList;
    }

    @NotNull
    private static List<String> readLines(@NotNull String body) {
        if (body == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/FileRuleSet.readLines must not be null");
        }
        List<String> list = StringUtil.split(body, true, '\n', '\r');
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/FileRuleSet.readLines must not return null");
        }
        return list;
    }

    @NotNull
    protected static String preparePath(@Nullable String path) {
        String string = FileRule.prepareRulePath(path);
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/FileRuleSet.preparePath must not return null");
        }
        return string;
    }

    private void init(@NotNull List<String> body) {
        if (body == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/FileRuleSet.init must not be null");
        }
        boolean hasExcludeAll = false;
        for (String line : body) {
            if (line.startsWith("#")) continue;
            if (line.startsWith("-:")) {
                String newExcludeRule = this.createNewExcludeRule((ExcludeRuleClass)line.substring(2));
                this.myExcludeRules.add(newExcludeRule);
                if (!((FileRule)((Object)newExcludeRule)).isRoot()) continue;
                hasExcludeAll = true;
                continue;
            }
            String rule = line;
            if (rule.startsWith("+:")) {
                rule = rule.substring(2).trim();
            }
            this.myIncludeRules.add(this.createNewIncludeRule((IncludeRuleClass)rule));
        }
        this.postProcessCreatedRules(this.myIncludeRules, this.myExcludeRules);
        if (this.myIncludeRules.isEmpty() && !hasExcludeAll) {
            this.myIncludeRules.add(this.createNewIncludeRule((IncludeRuleClass)""));
        }
        this.doPostInitProcess(this.myIncludeRules, this.myExcludeRules);
    }

    protected void postProcessCreatedRules(List<IncludeRuleClass> includeRules, List<ExcludeRuleClass> excludeRules) {
    }

    protected abstract void doPostInitProcess(List<IncludeRuleClass> var1, List<ExcludeRuleClass> var2);

    protected abstract IncludeRuleClass createNewIncludeRule(String var1);

    protected abstract ExcludeRuleClass createNewExcludeRule(String var1);

    protected static void sortByFrom(List<? extends FileRule> rules, boolean reverse) {
        Collections.sort(rules, new Comparator<FileRule>(){

            @Override
            public int compare(FileRule o1, FileRule o2) {
                if (o1.getFrom().equals(o2.getFrom())) {
                    return FileRuleSet.compareProperties(o1, o2);
                }
                return o1.getFrom().compareTo(o2.getFrom());
            }
        });
        if (reverse) {
            Collections.reverse(rules);
        }
    }

    private static int compareProperties(FileRule o1, FileRule o2) {
        Map<String, String> props1 = o1.getAdditionalProperties();
        Map<String, String> props2 = o2.getAdditionalProperties();
        if (props1 == null && props2 == null) {
            return 0;
        }
        if (props1 == null) {
            return -1;
        }
        if (props2 == null) {
            return 1;
        }
        return PropertiesUtil.compareProperties(props1, props2);
    }

    public List<IncludeRuleClass> getIncludeRules() {
        return Collections.unmodifiableList(this.myIncludeRules);
    }

    public List<ExcludeRuleClass> getExcludeRules() {
        return Collections.unmodifiableList(this.myExcludeRules);
    }

    public List<String> getBody() {
        return this.myBody;
    }

    public FileRuleSet(List<IncludeRuleClass> includeRules, List<ExcludeRuleClass> excludeRules) {
        this.myBody = new ArrayList<String>(includeRules.size() + excludeRules.size());
        this.myIncludeRules = new ArrayList<IncludeRuleClass>(includeRules.size());
        this.myExcludeRules = new ArrayList<ExcludeRuleClass>(excludeRules.size());
        for (FileRule includeRule : includeRules) {
            this.myIncludeRules.add(this.createNewIncludeRule(includeRule));
        }
        for (FileRule excludeRule : excludeRules) {
            this.myExcludeRules.add(this.createNewExcludeRule(excludeRule));
        }
        FileRuleSet.sortByFrom(this.myIncludeRules, true);
        FileRuleSet.sortByFrom(this.myExcludeRules, true);
        for (FileRule includeRule : includeRules) {
            this.myBody.add(includeRule.toString());
        }
        for (FileRule excludeRule : excludeRules) {
            this.myBody.add("-:" + excludeRule.toString());
        }
    }

    protected abstract IncludeRuleClass createNewIncludeRule(IncludeRuleClass var1);

    protected abstract ExcludeRuleClass createNewExcludeRule(ExcludeRuleClass var1);

    public boolean shouldInclude(String path, Map<String, String> props) {
        return this.shouldInclude(path, this.createPropertiesFilter(props));
    }

    protected boolean shouldInclude(String path, @NotNull Filter<FileRule> includeExcludeRulesFilter) {
        if (includeExcludeRulesFilter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/vcs/FileRuleSet.shouldInclude must not be null");
        }
        return FileRuleSet.shouldInclude(path, this.getIncludeRules(includeExcludeRulesFilter), this.getExcludeRules(includeExcludeRulesFilter));
    }

    protected static boolean shouldInclude(String path, @NotNull List<FileRule> includeRules, @NotNull List<FileRule> excludeRules) {
        if (includeRules == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/vcs/FileRuleSet.shouldInclude must not be null");
        }
        if (excludeRules == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/vcs/FileRuleSet.shouldInclude must not be null");
        }
        FileRule inc = FileRuleSet.findMostSpecific(path = FileRuleSet.preparePath(path), includeRules);
        if (inc == null) {
            return false;
        }
        FileRule excl = FileRuleSet.findMostSpecific(path, excludeRules);
        if (excl == null) {
            return true;
        }
        String from1 = inc.getMatchedHead(path);
        String from2 = excl.getMatchedHead(path);
        if (from1 == null || from2 == null) {
            return false;
        }
        if (from1.equals(from2)) {
            return FileRuleSet.compareProperties(inc, excl) > 0;
        }
        return FileRuleSet.isSubDir(from1, from2);
    }

    @NotNull
    protected List<FileRule> getExcludeRules(Filter<FileRule> filter) {
        List list = FilterUtil.filterCollection(new ArrayList<ExcludeRuleClass>(this.myExcludeRules), filter);
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/FileRuleSet.getExcludeRules must not return null");
        }
        return list;
    }

    @NotNull
    protected List<FileRule> getIncludeRules(Filter<FileRule> filter) {
        List list = FilterUtil.filterCollection(new ArrayList<IncludeRuleClass>(this.myIncludeRules), filter);
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/FileRuleSet.getIncludeRules must not return null");
        }
        return list;
    }

    @NotNull
    protected Filter<FileRule> createPropertiesFilter(final Map<String, String> props) {
        Filter<FileRule> filter = new Filter<FileRule>(){

            @Override
            public boolean accept(@NotNull FileRule rule) {
                if (rule == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/FileRuleSet$2.accept must not be null");
                }
                return rule.propertiesMatch(props);
            }
        };
        if (filter == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/FileRuleSet.createPropertiesFilter must not return null");
        }
        return filter;
    }

    public boolean shouldInclude(String path) {
        return this.shouldInclude(path, Collections.<String, String>emptyMap());
    }

    public boolean shouldInclude(String path, IncludeRule rule) {
        IncludeRuleClass inc = FileRuleSet.findMostSpecific(path = FileRuleSet.preparePath(path), this.getIncludeRules());
        if (inc == null) {
            return false;
        }
        ExcludeRuleClass excl = FileRuleSet.findMostSpecific(path, this.getExcludeRules());
        return (excl == null || FileRuleSet.isSubDir(((FileRule)inc).getFrom(), ((FileRule)excl).getFrom())) && rule.equals(inc);
    }

    @Nullable
    public IncludeRuleClass getIncludeRuleFor(String path) {
        IncludeRuleClass inc = FileRuleSet.findMostSpecific(path = FileRuleSet.preparePath(path), this.getIncludeRules());
        if (inc == null) {
            return null;
        }
        ExcludeRuleClass excl = FileRuleSet.findMostSpecific(path, this.getExcludeRules());
        if (excl != null && !FileRuleSet.isSubDir(((FileRule)inc).getFrom(), ((FileRule)excl).getFrom())) {
            return null;
        }
        return inc;
    }

    public static boolean isSubDir(String child, String parent) {
        if (parent.equals(child)) {
            return true;
        }
        if (parent.length() == 0) {
            return true;
        }
        return child.startsWith(parent + "/");
    }

    @Nullable
    public IncludeRuleClass getIncludeRuleMerged() {
        List<IncludeRuleClass> rules = this.getIncludeRules();
        if (rules.size() == 0) {
            return null;
        }
        if (rules.size() == 1) {
            return (IncludeRuleClass)((FileRule)rules.get(0));
        }
        String commonPath = this.withSlash(((FileRule)rules.get(0)).getFrom());
        for (FileRule rule : rules) {
            commonPath = StringUtil.commonPrefix((String)commonPath, (String)this.withSlash(rule.getFrom()));
        }
        int lastSlash = commonPath.lastIndexOf(47);
        commonPath = lastSlash >= 0 ? commonPath.substring(0, lastSlash) : "";
        return (IncludeRuleClass)this.createNewIncludeRule((IncludeRuleClass)commonPath);
    }

    private String withSlash(String from) {
        if ("".equals(from) || from.endsWith("/")) {
            return from;
        }
        return from + "/";
    }

    @Nullable
    protected static <T extends FileRule> T findMostSpecific(String path, List<T> rules) {
        FileRule result = null;
        String resultFrom = "";
        for (FileRule rule : rules) {
            String from = rule.getMatchedHead(path);
            if (from == null) continue;
            if (result == null) {
                result = rule;
                resultFrom = from;
                continue;
            }
            if (resultFrom.length() >= from.length()) continue;
            result = rule;
            resultFrom = from;
        }
        return (T)result;
    }
}

