/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.buildServer.vcs.VcsChangeInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VcsChange
implements VcsChangeInfo {
    @Nullable
    private final String myChangeTypeName;
    private final String myFileName;
    private final int myRelNamePos;
    private final String myRelativeFileName;
    private final VcsChangeInfo.Type myType;
    @Nullable
    private final String myBeforeChangeRevisionNumber;
    @Nullable
    private final String myAfterChangeRevisionNumber;

    public VcsChange(@NotNull VcsChangeInfo.Type type, @Nullable String changeName, @NotNull String fileName, @NotNull String relativeFileName, @Nullable String beforeNum, @Nullable String afterNum) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        if (relativeFileName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        this.myChangeTypeName = changeName != null && !changeName.equals(type.getDescription()) ? changeName : null;
        this.myFileName = fileName;
        int pos = fileName.indexOf(relativeFileName);
        if (pos == -1 || pos + relativeFileName.length() != fileName.length()) {
            this.myRelativeFileName = relativeFileName;
            this.myRelNamePos = -1;
        } else {
            this.myRelativeFileName = null;
            this.myRelNamePos = pos;
        }
        this.myType = type;
        this.myBeforeChangeRevisionNumber = beforeNum;
        this.myAfterChangeRevisionNumber = afterNum;
    }

    public VcsChange(@NotNull VcsChangeInfo.Type type, @NotNull String fileName, @NotNull String relativeFileName, @Nullable String beforeNum, @Nullable String afterNum) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        if (relativeFileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        this(type, null, fileName, relativeFileName, beforeNum, afterNum);
    }

    protected VcsChange(@NotNull VcsChangeInfo source) {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        this(source.getType(), source.getChangeTypeName(), source.getFileName(), source.getRelativeFileName(), source.getBeforeChangeRevisionNumber(), source.getAfterChangeRevisionNumber());
    }

    public static List<VcsChange> createList(@Nullable Collection<? extends VcsChangeInfo> source) {
        if (source == null) {
            return null;
        }
        ArrayList<VcsChange> result = new ArrayList<VcsChange>();
        for (VcsChangeInfo vcsChangeInfo : source) {
            result.add(new VcsChange(vcsChangeInfo));
        }
        return result;
    }

    public static VcsChange forTest() {
        return new VcsChange(VcsChangeInfo.Type.CHANGED, "changed", "svn:/path/file.txt", "path/file.txt", "1", "2");
    }

    @Override
    @Nullable
    public String getChangeTypeName() {
        return this.myChangeTypeName == null ? this.myType.getDescription() : this.myChangeTypeName;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/VcsChange.getFileName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getRelativeFileName() {
        if (this.myRelNamePos >= 0) {
            String string = this.myFileName.substring(this.myRelNamePos);
            if (string == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/VcsChange.getRelativeFileName must not return null");
            }
            return string;
        }
        String string = this.myRelativeFileName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/VcsChange.getRelativeFileName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public VcsChangeInfo.Type getType() {
        VcsChangeInfo.Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/VcsChange.getType must not return null");
        }
        return type;
    }

    @Override
    @Nullable
    public String getBeforeChangeRevisionNumber() {
        return this.myBeforeChangeRevisionNumber;
    }

    @Override
    @Nullable
    public String getAfterChangeRevisionNumber() {
        return this.myAfterChangeRevisionNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsChange vcsChange = (VcsChange)o;
        if (this.myRelNamePos != vcsChange.myRelNamePos) {
            return false;
        }
        if (this.myAfterChangeRevisionNumber != null ? !this.myAfterChangeRevisionNumber.equals(vcsChange.myAfterChangeRevisionNumber) : vcsChange.myAfterChangeRevisionNumber != null) {
            return false;
        }
        if (this.myBeforeChangeRevisionNumber != null ? !this.myBeforeChangeRevisionNumber.equals(vcsChange.myBeforeChangeRevisionNumber) : vcsChange.myBeforeChangeRevisionNumber != null) {
            return false;
        }
        if (this.myChangeTypeName != null ? !this.myChangeTypeName.equals(vcsChange.myChangeTypeName) : vcsChange.myChangeTypeName != null) {
            return false;
        }
        if (!this.myFileName.equals(vcsChange.myFileName)) {
            return false;
        }
        if (this.myRelativeFileName != null ? !this.myRelativeFileName.equals(vcsChange.myRelativeFileName) : vcsChange.myRelativeFileName != null) {
            return false;
        }
        return this.myType == vcsChange.myType;
    }

    public int hashCode() {
        int result = this.myChangeTypeName != null ? this.myChangeTypeName.hashCode() : 0;
        result = 31 * result + this.myFileName.hashCode();
        result = 31 * result + this.myRelNamePos;
        result = 31 * result + (this.myRelativeFileName != null ? this.myRelativeFileName.hashCode() : 0);
        result = 31 * result + this.myType.hashCode();
        result = 31 * result + (this.myBeforeChangeRevisionNumber != null ? this.myBeforeChangeRevisionNumber.hashCode() : 0);
        result = 31 * result + (this.myAfterChangeRevisionNumber != null ? this.myAfterChangeRevisionNumber.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "VcsChange{myChangeTypeName='" + this.myChangeTypeName + '\'' + ", myFileName='" + this.myFileName + '\'' + ", myRelNamePos=" + this.myRelNamePos + ", myRelativeFileName='" + this.myRelativeFileName + '\'' + ", myType=" + (Object)((Object)this.myType) + ", myBeforeChangeRevisionNumber='" + this.myBeforeChangeRevisionNumber + '\'' + ", myAfterChangeRevisionNumber='" + this.myAfterChangeRevisionNumber + '\'' + '}';
    }
}

