/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.Map;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.vcs.VcsException;
import jetbrains.buildServer.vcs.VcsRoot;
import org.jetbrains.annotations.NotNull;

public class VcsRootVcsException
extends VcsException {
    private final VcsRoot myRoot;
    private final boolean myIsDetailed;

    private VcsRootVcsException(@NotNull VcsRoot root, @NotNull String message, @NotNull VcsException cause, boolean isDetailed) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/VcsRootVcsException.<init> must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/vcs/VcsRootVcsException.<init> must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/vcs/VcsRootVcsException.<init> must not be null");
        }
        super(VcsRootVcsException.replaceSecured(root, message + cause.getMessage()), cause);
        this.myRoot = root;
        this.myIsDetailed = isDetailed;
    }

    private static String replaceSecured(@NotNull VcsRoot root, @NotNull String msg) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/VcsRootVcsException.replaceSecured must not be null");
        }
        if (msg == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/vcs/VcsRootVcsException.replaceSecured must not be null");
        }
        Map<String, String> props = root.getProperties();
        for (String key : props.keySet()) {
            String value;
            if (!key.startsWith("secure:") || StringUtil.isEmpty((String)(value = props.get(key)))) continue;
            msg = msg.replace(value, "*****");
        }
        return msg;
    }

    public VcsRootVcsException(@NotNull VcsRoot root, @NotNull String message, @NotNull VcsException cause) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/VcsRootVcsException.<init> must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/vcs/VcsRootVcsException.<init> must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/vcs/VcsRootVcsException.<init> must not be null");
        }
        this(root, message, cause, true);
    }

    public VcsRootVcsException(@NotNull VcsRoot root, @NotNull VcsException cause) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/VcsRootVcsException.<init> must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/vcs/VcsRootVcsException.<init> must not be null");
        }
        this(root, "", cause, false);
    }

    @NotNull
    public VcsRoot getRoot() {
        VcsRoot vcsRoot = this.myRoot;
        if (vcsRoot == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/VcsRootVcsException.getRoot must not return null");
        }
        return vcsRoot;
    }

    public boolean isDetailed() {
        return this.myIsDetailed;
    }
}

