/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.xstream;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jetbrains.buildServer.messages.XStreamHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamWrapper {
    private XStreamWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> deserializeObjects(@NotNull Collection objectsXml, @NotNull XStreamHolder holder) {
        if (objectsXml == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.deserializeObjects must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.deserializeObjects must not be null");
        }
        ArrayList<Object> messages = new ArrayList<Object>();
        XStream xStream = holder.getXStream();
        try {
            for (Object nodeObj : objectsXml) {
                if (!(nodeObj instanceof String)) continue;
                String messageXml = (String)nodeObj;
                try {
                    messages.add(XStreamWrapper.fromXML(xStream, messageXml));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            holder.releaseXStream(xStream);
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> deserializeObjects(@NotNull Class<T> clazz, @NotNull ClassLoader classLoader, @NotNull Collection objectsXml, @NotNull XStreamHolder holder) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.deserializeObjects must not be null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.deserializeObjects must not be null");
        }
        if (objectsXml == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.deserializeObjects must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.deserializeObjects must not be null");
        }
        ArrayList<T> messages = new ArrayList<T>();
        XStream xStream = holder.getXStream(classLoader);
        try {
            for (Object nodeObj : objectsXml) {
                if (!(nodeObj instanceof String)) continue;
                String messageXml = (String)nodeObj;
                try {
                    messages.add(clazz.cast(XStreamWrapper.fromXML(xStream, messageXml)));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            holder.releaseXStream(xStream);
        }
        return messages;
    }

    private static Object fromXML(@NotNull XStream xStream, @NotNull String messageXml) {
        if (xStream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.fromXML must not be null");
        }
        if (messageXml == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.fromXML must not be null");
        }
        return xStream.fromXML(messageXml);
    }

    public static <T> Vector serializeObjects(@NotNull List<T> list, @NotNull XStreamHolder holder) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.serializeObjects must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.serializeObjects must not be null");
        }
        return XStreamWrapper.serializeObjectsInternal(list, holder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Vector serializeObjectsInternal(@NotNull List<T> list, @NotNull XStreamHolder holder, @Nullable ClassLoader classLoader) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.serializeObjectsInternal must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.serializeObjectsInternal must not be null");
        }
        Vector<String> result = new Vector<String>();
        XStream xStream = holder.getXStream(classLoader);
        try {
            for (T buildMessage : list) {
                result.add(XStreamWrapper.toXML(buildMessage, xStream));
            }
        }
        finally {
            holder.releaseXStream(xStream);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String serializeObject(@Nullable Object obj, @NotNull XStreamHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.serializeObject must not be null");
        }
        if (obj != null) {
            XStream xStream = holder.getXStream(obj.getClass().getClassLoader());
            String string = XStreamWrapper.toXML(obj, xStream);
            String string2 = string;
            if (string2 == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/xstream/XStreamWrapper.serializeObject must not return null");
            }
            return string2;
            finally {
                holder.releaseXStream(xStream);
            }
        }
        if ("" == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/xstream/XStreamWrapper.serializeObject must not return null");
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String toXML(@NotNull Object obj, @NotNull XStream xStream) {
        if (obj == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.toXML must not be null");
        }
        if (xStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.toXML must not be null");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                xStream.toXML(obj, (OutputStream)out);
            }
            finally {
                out.close();
            }
            String string = new String(out.toByteArray(), "UTF-8");
            if (string == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/xstream/XStreamWrapper.toXML must not return null");
            }
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = xStream.toXML(obj);
            if (string == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/xstream/XStreamWrapper.toXML must not return null");
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static byte[] serializeAndZipObject(@Nullable Object obj, @NotNull XStreamHolder holder) throws IOException {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.serializeAndZipObject must not be null");
        }
        if (obj != null) {
            XStream xStream = holder.getXStream(obj.getClass().getClassLoader());
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new GZIPOutputStream(buffer), "UTF-8");
                try {
                    xStream.toXML(obj, (Writer)out);
                }
                finally {
                    ((Writer)out).close();
                }
                byte[] byArray = buffer.toByteArray();
                if (byArray == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/xstream/XStreamWrapper.serializeAndZipObject must not return null");
                }
                return byArray;
            }
            finally {
                holder.releaseXStream(xStream);
            }
        }
        byte[] byArray = new byte[]{};
        if (byArray == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/xstream/XStreamWrapper.serializeAndZipObject must not return null");
        }
        return byArray;
    }

    @Nullable
    public static <T> T deserializeObject(@Nullable String xml, @NotNull XStreamHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.deserializeObject must not be null");
        }
        return XStreamWrapper.deserializeObjectInternal(xml, holder, null);
    }

    @Nullable
    public static <T> T deserializeObject(@NotNull ClassLoader classLoader, @Nullable String xml, @NotNull XStreamHolder holder) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.deserializeObject must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.deserializeObject must not be null");
        }
        return XStreamWrapper.deserializeObjectInternal(xml, holder, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static <T> T deserializeObjectInternal(@Nullable String xml, @NotNull XStreamHolder holder, @Nullable ClassLoader classloader) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.deserializeObjectInternal must not be null");
        }
        if (xml != null && xml.length() > 0) {
            XStream xStream = holder.getXStream(classloader);
            try {
                Object object = XStreamWrapper.fromXML(xStream, xml);
                return (T)object;
            }
            finally {
                holder.releaseXStream(xStream);
            }
        }
        return null;
    }

    @Nullable
    public static <T> T unzipAndDeserializeObject(@Nullable byte[] zipped, @NotNull XStreamHolder holder) throws IOException {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.unzipAndDeserializeObject must not be null");
        }
        return XStreamWrapper.unzipAndDeserializedObjectInternal(zipped, holder, null);
    }

    @Nullable
    public static <T> T unzipAndDeserializeObject(@NotNull ClassLoader classLoader, @Nullable byte[] zipped, @NotNull XStreamHolder holder) throws IOException {
        if (classLoader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.unzipAndDeserializeObject must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.unzipAndDeserializeObject must not be null");
        }
        return XStreamWrapper.unzipAndDeserializedObjectInternal(zipped, holder, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static <T> T unzipAndDeserializedObjectInternal(@Nullable byte[] zipped, @NotNull XStreamHolder holder, @Nullable ClassLoader classLoader) throws IOException {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/xstream/XStreamWrapper.unzipAndDeserializedObjectInternal must not be null");
        }
        if (zipped != null && zipped.length > 0) {
            XStream xStream = holder.getXStream(classLoader);
            try {
                Object object;
                ByteArrayInputStream inBuffer = new ByteArrayInputStream(zipped);
                GZIPInputStream zipIn = new GZIPInputStream(inBuffer);
                InputStreamReader reader = new InputStreamReader((InputStream)zipIn, "UTF-8");
                try {
                    object = xStream.fromXML((Reader)reader);
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return (T)object;
            }
            finally {
                holder.releaseXStream(xStream);
            }
        }
        return null;
    }
}

