/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.vcs.api;

import java.util.Collections;
import java.util.Map;
import jetbrains.buildServer.log.Loggable;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.impl.VcsRootImpl;
import jetbrains.vcs.api.data.VcsDataObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VcsSettings
implements Loggable,
VcsDataObject {
    @NotNull
    private final VcsRoot myVcsRoot;
    @NotNull
    private final String myCheckoutRules;

    public VcsSettings(@NotNull VcsRoot vcsRoot, @NotNull String checkoutRules) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/vcs/api/VcsSettings.<init> must not be null");
        }
        if (checkoutRules == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/vcs/api/VcsSettings.<init> must not be null");
        }
        this.myVcsRoot = vcsRoot;
        this.myCheckoutRules = checkoutRules;
    }

    /*
     * WARNING - void declaration
     */
    public VcsSettings(long settingsId, @NotNull String vcsName, @Nullable String displayName, @NotNull String checkoutRules, @NotNull Map<String, String> map) {
        void properties;
        if (vcsName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/vcs/api/VcsSettings.<init> must not be null");
        }
        if (checkoutRules == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of jetbrains/vcs/api/VcsSettings.<init> must not be null");
        }
        if (map == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of jetbrains/vcs/api/VcsSettings.<init> must not be null");
        }
        VcsRootImpl vcsRoot = new VcsRootImpl(settingsId, vcsName, (Map<String, String>)properties);
        if (displayName != null) {
            vcsRoot.setName(displayName);
        }
        this.myVcsRoot = vcsRoot;
        this.myCheckoutRules = checkoutRules;
    }

    @NotNull
    public VcsRoot getVcsRoot() {
        VcsRoot vcsRoot = this.myVcsRoot;
        if (vcsRoot == null) {
            throw new IllegalStateException("@NotNull method jetbrains/vcs/api/VcsSettings.getVcsRoot must not return null");
        }
        return vcsRoot;
    }

    public long getSettingsId() {
        return this.myVcsRoot.getId();
    }

    @Nullable
    public String getDisplayName() {
        return this.myVcsRoot.getName();
    }

    @NotNull
    public String getVcsName() {
        String string = this.myVcsRoot.getVcsName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/vcs/api/VcsSettings.getVcsName must not return null");
        }
        return string;
    }

    @NotNull
    public Map<String, String> getProperties() {
        Map<String, String> map = this.myVcsRoot.getProperties();
        if (map == null) {
            throw new IllegalStateException("@NotNull method jetbrains/vcs/api/VcsSettings.getProperties must not return null");
        }
        return map;
    }

    @NotNull
    public String getCheckoutRulesSpecification() {
        String string = this.myCheckoutRules;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/vcs/api/VcsSettings.getCheckoutRulesSpecification must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String describe(boolean verbose) {
        String string = "VcsSettings[" + this.myVcsRoot.describe(verbose) + "; Checkout rules: " + this.myCheckoutRules + "]";
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/vcs/api/VcsSettings.describe must not return null");
        }
        return string;
    }

    public String toString() {
        return this.describe(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VcsSettings)) {
            return false;
        }
        VcsSettings that = (VcsSettings)o;
        if (!this.myCheckoutRules.equals(that.myCheckoutRules)) {
            return false;
        }
        return this.myVcsRoot.equals(that.myVcsRoot);
    }

    public int hashCode() {
        int result = this.myVcsRoot.hashCode();
        result = 31 * result + this.myCheckoutRules.hashCode();
        return result;
    }

    public static VcsSettings forTest(String name) {
        return new VcsSettings(name.hashCode(), name, name, "", Collections.<String, String>emptyMap());
    }
}

