/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.buildServer.ExecResult;
import jetbrains.buildServer.StreamGobbler;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.NamedThreadUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineExecutor {
    private final ExecResult myRetVal = new ExecResult();
    private final GeneralCommandLine myCommandLine;
    private Process myProc;
    private StreamGobbler myErrorGobbler;
    private StreamGobbler myOutputGobbler;
    private OutputStream myOutputStream;
    private static final int TIMEOUT_DEF = 90;
    private static final int TIMEOUT_SECONDS = CommandLineExecutor.getTimeOutValue();
    private static final Logger LOG = Logger.getInstance((String)CommandLineExecutor.class.getName());

    private static int getTimeOutValue() {
        return TeamCityProperties.getInteger("teamcity.execution.timeout", 90);
    }

    public CommandLineExecutor(GeneralCommandLine commandLine) {
        this.myCommandLine = commandLine;
    }

    public ExecResult runProcess() throws ExecutionException {
        this.myProc = this.myCommandLine.createProcess();
        this.myErrorGobbler = new StreamGobbler(this.myProc.getErrorStream());
        this.myOutputGobbler = new StreamGobbler(this.myProc.getInputStream());
        this.myErrorGobbler.start();
        this.myOutputGobbler.start();
        return this.waitFor();
    }

    public OutputStream getOutputStream() {
        if (this.myOutputStream == null) {
            this.myOutputStream = this.myProc.getOutputStream();
        }
        return this.myOutputStream;
    }

    public ExecResult waitFor() {
        try {
            this.myRetVal.setExitCode(CommandLineExecutor.waitForProcess(this.myProc, this.myErrorGobbler, this.myOutputGobbler));
            this.myRetVal.setOutputGobbler(this.myOutputGobbler);
            this.myRetVal.setErrorGobbler(this.myErrorGobbler);
        }
        catch (Throwable e) {
            this.myRetVal.setException(e);
        }
        return this.myRetVal;
    }

    public Process getProcess() {
        return this.myProc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finalizeAll(Process proc, StreamGobbler errorGobbler, StreamGobbler outputGobbler) throws InterruptedException {
        errorGobbler.notifyProcessExit();
        outputGobbler.notifyProcessExit();
        try {
            try {
                CommandLineExecutor.shutdownGobbler(outputGobbler, "stdout", proc.getInputStream());
            }
            finally {
                CommandLineExecutor.shutdownGobbler(errorGobbler, "stderr", proc.getErrorStream());
            }
        }
        finally {
            CommandLineExecutor.destroySilently(proc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownGobbler(StreamGobbler gobbler, String error, Closeable stream) throws InterruptedException {
        try {
            LOG.debug("Start waiting for " + error + " collector thread");
            gobbler.join();
            LOG.debug("Finished waiting for " + error + " collector thread");
        }
        finally {
            FileUtil.close(stream);
        }
    }

    public static int waitForProcess(Process proc, StreamGobbler errorGobbler, StreamGobbler outputGobbler) throws InterruptedException {
        return CommandLineExecutor.waitForProcess(proc, errorGobbler, outputGobbler, TIMEOUT_SECONDS);
    }

    public static int waitForProcess(Process proc, StreamGobbler errorGobbler, StreamGobbler outputGobbler, int idleTimeoutSeconds) throws InterruptedException {
        AtomicReference<Integer> result = new AtomicReference<Integer>();
        InterruptedException[] ex = new InterruptedException[1];
        LOG.debug("Start waiting for process finishing");
        Thread waitThread = CommandLineExecutor.createWaitForProcessThread(proc, errorGobbler, outputGobbler, result, ex);
        waitThread.start();
        long lastReadErr = errorGobbler.getLastActivityTimestamp();
        long lastReadOut = outputGobbler.getLastActivityTimestamp();
        while (true) {
            boolean outputAbsent = true;
            for (int i = 0; i < 100; ++i) {
                waitThread.join(idleTimeoutSeconds * 10);
                if (ex[0] != null) {
                    throw ex[0];
                }
                if (result.get() != null || !(outputAbsent = CommandLineExecutor.outputAbsent(errorGobbler, outputGobbler, lastReadErr, lastReadOut))) break;
            }
            if (result.get() != null) break;
            if (outputAbsent) {
                CommandLineExecutor.destroySilently(proc);
                throw new InterruptedException("Timeout exception");
            }
            lastReadErr = errorGobbler.getLastActivityTimestamp();
            lastReadOut = outputGobbler.getLastActivityTimestamp();
        }
        LOG.debug("Stop waiting for process finishing");
        return result.get();
    }

    private static void destroySilently(Process proc) {
        try {
            proc.destroy();
        }
        catch (Throwable e) {
            LOG.debug("Failed to destroy process: " + e.toString(), e);
        }
    }

    private static boolean outputAbsent(StreamGobbler errorGobbler, StreamGobbler outputGobbler, long lastReadErr, long lastReadOut) {
        return lastReadErr == errorGobbler.getLastActivityTimestamp() && lastReadOut == outputGobbler.getLastActivityTimestamp();
    }

    private static Thread createWaitForProcessThread(final Process proc, final StreamGobbler errorGobbler, final StreamGobbler outputGobbler, final AtomicReference<Integer> result, final InterruptedException[] ex) {
        final String curThreadName = Thread.currentThread().getName();
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread.currentThread().setName(NamedThreadUtil.getTcThreadPrefix() + "Wait for process: " + curThreadName);
                Integer execResult = null;
                try {
                    execResult = proc.waitFor();
                    LOG.debug("Process.waitFor() finished");
                }
                catch (InterruptedException e) {
                    LOG.warn("Failed to Process.waitFor(): " + e.getLocalizedMessage(), (Throwable)e);
                    ex[0] = e;
                }
                finally {
                    try {
                        CommandLineExecutor.finalizeAll(proc, errorGobbler, outputGobbler);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        result.set(execResult);
                    }
                }
            }
        });
    }
}

