/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.lang.reflect.Field;
import java.util.ArrayList;
import jetbrains.buildServer.ComparisonFailureData;

public class ComparisonFailureUtil {
    private static final String COMPARISON_FAILURE_PREFIX = "expected:<";
    private static final String JAVA_LANG_ASSERTION_ERROR = "java.lang.AssertionError";
    private static final String TNG66_EXPECTED = "expected [";
    private static final String TNG66_BUT_FOUND = "] but found [";
    private static final String TNG66_END = "]";

    public static ComparisonFailureData extractComparisonFailure(Throwable t) {
        Class[] comparisonFailureClasses = ComparisonFailureUtil.getComparisonFailureClasses(t.getClass().getClassLoader());
        for (int i = 0; i < comparisonFailureClasses.length; ++i) {
            Class cl = comparisonFailureClasses[i];
            if (!cl.isAssignableFrom(t.getClass())) continue;
            try {
                String expected = ComparisonFailureUtil.getExpected(t);
                String actual = ComparisonFailureUtil.getActual(t);
                return new ComparisonFailureData(expected, actual);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        String message = t.getLocalizedMessage();
        if (t.getClass().getName().equals(JAVA_LANG_ASSERTION_ERROR) && message != null) {
            if (message.startsWith(COMPARISON_FAILURE_PREFIX)) {
                return ComparisonFailureUtil.extractComparisonFailureFromAssertionError(t);
            }
            if (message.indexOf(TNG66_EXPECTED) >= 0) {
                return ComparisonFailureUtil.extractComparisonFailureFromAssertionErrorTestNG6_6(t);
            }
        }
        return null;
    }

    private static ComparisonFailureData extractComparisonFailureFromAssertionError(Throwable t) {
        String message = t.getLocalizedMessage();
        String butWasStr = "> but was:<";
        int butWasIdx = message.indexOf(butWasStr);
        int lastChar = message.lastIndexOf(62);
        if (butWasIdx == -1 || lastChar == -1) {
            return null;
        }
        String expected = message.substring(COMPARISON_FAILURE_PREFIX.length(), butWasIdx);
        String actual = message.substring(butWasIdx + butWasStr.length(), lastChar);
        return new ComparisonFailureData(expected, actual);
    }

    private static ComparisonFailureData extractComparisonFailureFromAssertionErrorTestNG6_6(Throwable t) {
        String message = t.getLocalizedMessage();
        int expectedIndex = message.indexOf(TNG66_EXPECTED);
        int butIndex = message.indexOf(TNG66_BUT_FOUND, expectedIndex + TNG66_EXPECTED.length());
        int endIndex = message.lastIndexOf(TNG66_END);
        if (expectedIndex == -1 || butIndex == -1 || endIndex == -1) {
            return null;
        }
        String expected = message.substring(expectedIndex + TNG66_EXPECTED.length(), butIndex);
        String actual = message.substring(butIndex + TNG66_BUT_FOUND.length(), endIndex);
        return new ComparisonFailureData(expected, actual);
    }

    private static String getActual(Throwable comparisonFailure) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureUtil.getFieldValue(comparisonFailure, "fActual");
    }

    private static String getExpected(Throwable comparisonFailure) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureUtil.getFieldValue(comparisonFailure, "fExpected");
    }

    private static String getFieldValue(Throwable comparisonFailure, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field expectedField = comparisonFailure.getClass().getDeclaredField(fieldName);
        expectedField.setAccessible(true);
        return (String)expectedField.get(comparisonFailure);
    }

    private static Class[] getComparisonFailureClasses(ClassLoader cl) {
        ArrayList classes = new ArrayList();
        ArrayList<String> names = new ArrayList<String>();
        names.add("org.junit.ComparisonFailure");
        names.add("junit.framework.ComparisonFailure");
        for (int i = 0; i < names.size(); ++i) {
            try {
                classes.add(cl.loadClass((String)names.get(i)));
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return classes.toArray(new Class[0]);
    }
}

