/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.execution.process.ProcessNotCreatedException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class RunBuildException
extends Exception {
    private boolean myLogStacktrace = true;
    private String myErrorType = null;

    public RunBuildException(String message) {
        super(message);
    }

    public RunBuildException(String message, Throwable cause) {
        super(message, cause);
    }

    public RunBuildException(String message, Throwable cause, String errorType) {
        this(message, cause);
        this.myErrorType = errorType;
    }

    public RunBuildException(IOException cause) {
        this("Internal IO error: " + cause.getLocalizedMessage(), cause);
    }

    public RunBuildException(Throwable cause) {
        super(cause);
    }

    public boolean isLogStacktrace() {
        return this.myLogStacktrace;
    }

    public void setLogStacktrace(boolean logStacktrace) {
        this.myLogStacktrace = logStacktrace;
    }

    public String getErrorType() {
        return this.myErrorType;
    }

    public void setErrorType(String errorType) {
        this.myErrorType = errorType;
    }

    public void copyParameters(@NotNull RunBuildException fromException) {
        if (fromException == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromException", "jetbrains/buildServer/RunBuildException", "copyParameters"));
        }
        this.setErrorType(fromException.getErrorType());
        this.setLogStacktrace(fromException.isLogStacktrace());
    }

    public static RunBuildException create(ProcessNotCreatedException source, String commandLine) {
        RunBuildException result;
        if (RunBuildException.isFileNotFound(source)) {
            result = new RunBuildException("Cannot run process " + commandLine + " : file not found", (Throwable)source);
            result.setLogStacktrace(false);
        } else {
            result = new RunBuildException("Cannot run process: " + source.getLocalizedMessage(), (Throwable)source);
        }
        return result;
    }

    private static boolean isFileNotFound(ProcessNotCreatedException e) {
        return !(!(e.getCause() instanceof IOException) && !e.getMessage().contains("CreateProcess:") || !e.getMessage().contains("error=2") && !e.getMessage().contains("error=3"));
    }
}

