/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import jetbrains.buildServer.util.NamedThreadUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StreamGobbler
extends Thread {
    private static final Logger LOG = Logger.getInstance((String)StreamGobbler.class.getName());
    private final ByteArrayOutputStream myByteContents;
    private final InputStream myInputStream;
    private final Integer myMaxAcceptedOutputSize;
    private final String myCommandDebug;
    private String myOutput;
    private volatile boolean myProcessExited;
    private volatile boolean myEndReached;
    private volatile boolean myOutputOverload;
    private volatile long myActivityTimestamp;

    public StreamGobbler(InputStream is) {
        this(is, null, "Unknown");
    }

    public StreamGobbler(InputStream inputStream, @Nullable Integer maxAcceptedOutputSize, @NotNull String commandDebug) {
        if (commandDebug == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandDebug", "jetbrains/buildServer/StreamGobbler", "<init>"));
        }
        this.myInputStream = inputStream;
        this.myByteContents = new ByteArrayOutputStream();
        this.myMaxAcceptedOutputSize = maxAcceptedOutputSize;
        this.myCommandDebug = commandDebug;
        this.myActivityTimestamp = System.currentTimeMillis();
    }

    public void notifyProcessExit() {
        this.myProcessExited = true;
    }

    public void run() {
        this.setName(NamedThreadUtil.getTcThreadPrefix() + "StreamGobbler: " + this.myCommandDebug);
        byte[] buffer = new byte[8192];
        try {
            while (!this.myEndReached) {
                Thread.yield();
                boolean probablyHasMoreData = false;
                if (this.myInputStream.available() > 0) {
                    Thread.yield();
                    probablyHasMoreData = this.readBuffer(buffer) == buffer.length;
                } else if (this.myProcessExited) {
                    while (this.myInputStream.available() > 0 && this.readBuffer(buffer) == buffer.length) {
                    }
                    break;
                }
                if (probablyHasMoreData) continue;
                Thread.sleep(10L);
            }
        }
        catch (IOException ioe) {
            LOG.debug(ioe.getMessage(), (Throwable)ioe);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int readBuffer(byte[] buffer) throws IOException {
        int read = this.myInputStream.read(buffer, 0, buffer.length);
        if (read > 0) {
            this.myActivityTimestamp = System.currentTimeMillis();
            if (this.myMaxAcceptedOutputSize == null || this.myByteContents.size() < this.myMaxAcceptedOutputSize) {
                this.myByteContents.write(buffer, 0, read);
            } else {
                if (!this.myOutputOverload) {
                    LOG.warn("Too large output was read from the stream (" + this.getReadLength() + " bytes), ignore the rest: " + this.myCommandDebug);
                }
                this.myOutputOverload = true;
            }
        }
        this.myEndReached = read == -1;
        return read;
    }

    public String getReadString(Charset encoding) {
        if (this.myOutput == null) {
            try {
                this.myOutput = StringUtil.convertLineSeparators((String)this.myByteContents.toString(encoding.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unable to convert output to encoding " + encoding, e);
            }
        }
        return this.myOutput;
    }

    public boolean isOutputOverload() {
        return this.myOutputOverload;
    }

    public byte[] getReadBytes() {
        return this.myByteContents.toByteArray();
    }

    public long getLastActivityTimestamp() {
        return this.myActivityTimestamp;
    }

    public long getReadLength() {
        return this.myByteContents.size();
    }
}

