/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import jetbrains.buildServer.agentServer.DetailsSerializationUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentRegistrationDetails {
    private final int myAgentId;
    private final String myAuthorizationToken;
    private final String myNewName;

    public AgentRegistrationDetails(int agentId, @Nullable String authorizationToken, @Nullable String newName) {
        this.myAgentId = agentId;
        this.myAuthorizationToken = authorizationToken;
        this.myNewName = newName;
    }

    public int getAgentId() {
        return this.myAgentId;
    }

    @Nullable
    public String getAuthorizationToken() {
        return this.myAuthorizationToken;
    }

    @Nullable
    public String getNewName() {
        return this.myNewName;
    }

    public String serializeToString() {
        Element rootElement = new Element("agentRegistrationData");
        Document document = new Document(rootElement);
        rootElement.setAttribute("agentId", String.valueOf(this.getAgentId()));
        this.saveAttribute(rootElement, "authToken", this.getAuthorizationToken());
        this.saveAttribute(rootElement, "newName", this.getNewName());
        try {
            return DetailsSerializationUtil.saveDocument(document);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void saveAttribute(Element rootElement, String key, String tok) {
        if (tok != null) {
            rootElement.setAttribute(key, tok);
        }
    }

    public static AgentRegistrationDetails deserializeFromString(@NotNull String code) {
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "jetbrains/buildServer/agentServer/AgentRegistrationDetails", "deserializeFromString"));
        }
        try {
            Document doc = DetailsSerializationUtil.loadDocument(code);
            Element rootElem = doc.getRootElement();
            String id = rootElem.getAttributeValue("agentId");
            String token = rootElem.getAttributeValue("authToken");
            String newName = rootElem.getAttributeValue("newName");
            return new AgentRegistrationDetails(Integer.parseInt(id), token, newName);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public String toString() {
        return "AgentRegistrationDetails{myAgentId=" + this.myAgentId + ", myAuthorizationToken='" + this.myAuthorizationToken + '\'' + ", myNewName='" + this.myNewName + '\'' + '}';
    }
}

